package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.*;
import com.elitescloud.cloudt.system.modules.orgtree.service.MultiOrgTreeQueryService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.MultiOrgTreeRepoProc;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeEmployeeDoRepo;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Service
@RequiredArgsConstructor
public class OrgBuTreeDServiceImpl implements OrgBuTreeDService {
    private final OrgBuTreeDDomainService orgBuTreeDDomainService;
    private final OrgBuTreeEmployeeDoRepo orgBuTreeEmployeeDoRepo;

    private final EmployeeRepoProc employeeRepoProc;
    private final MultiOrgTreeRepoProc multiOrgTreeRepoProc;

    private final EmployeeMngService employeeMngService;

    private final OrgBuTreeService orgBuTreeService;

    private final MultiOrgTreeQueryService multiOrgTreeQueryService;
    /**
     * 组织树明细新增
     *
     * @param paramList
     * @return
     */
    @Override
//    @CacheEvict(cacheNames = "ORG_BU_TREE", key = "'BU_TREE_ID_'+#paramList.get(0).buTreeId")
    @Transactional(rollbackFor = Exception.class)
    public List<OrgBuTreeDDetailVO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList) {
        List<OrgBuTreeDDetailDTO> orgBuTreeDDetailDTOList = orgBuTreeDDomainService.orgBuTreeDCreate(paramList);
        return OrgTreeConvert.INSTANCE.treeDDDtoToVo(orgBuTreeDDetailDTOList);
    }

    /**
     * 组织树节点删除
     *
     * @param id
     */
    @Override
//    @CacheEvict(cacheNames = "ORG_BU_TREE", key = "'BU_TREE_ID_'+#buTreeId")
    @Transactional(rollbackFor = Exception.class)
    public void deleteTreeDetail(Long id, Long buTreeId) {
        orgBuTreeDDomainService.deleteTreeDetail(id, buTreeId);
    }

    /**
     * 通过id查询所有下级
     * 通过id查询下一级
     *
     * @param id
     */
    @SysCodeProc
    @Override
    public List<OrgBuTreedAllVO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId) {
        List<OrgBuTreedAllDTO> orgBuTreedAllDTOS = orgBuTreeDDomainService.orgBuTreedAllSearch(id, searchType, buTreeId);
        return OrgTreeConvert.INSTANCE.treeDAllDtoToVo(orgBuTreedAllDTOS);
    }

    /**
     * 获取组织树形结构
     *
     * @param buTreeId
     * @return
     */
    @Override
    public List<OrgBuTreeDVO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId) {
        List<OrgBuTreeDDTO> orgBuTreeDDTOS = orgBuTreeDDomainService.orgBuTreeDSearchTree(buTreeId, searchType, buTreeDId);
        return OrgTreeConvert.INSTANCE.treeDDtoToVo(orgBuTreeDDTOS);
    }

    /**
     * 新增/编辑 组织树版本数据
     *
     * @param param 数据参数
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
//    @CacheEvict(cacheNames = "ORG_BU_TREE", key = "'BU_TREE_ID_' + #param.id", condition = "#param.id != null")
    public void saveBuTreeDV(OrgBuTreeVSaveParam param) {
        orgBuTreeDDomainService.saveBuTreeDV(param);
    }

    /**
     * 根据组织号获取组织版本信息
     *
     * @param buTreeCode 组织树编码
     * @return list
     */
    @Override
    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return orgBuTreeDDomainService.getBuTreeVersionByBuTreeCode(buTreeCode);
    }

    /**
     * 根据组织号获取所有组织树信息
     *
     * @param param 组织树编码
     * @return list
     */
    @Override
    public List<OrgBuTreeVO> getBuTreeListByParam(OrgBuTreeVListParam param) {
        List<OrgBuTreeDTO> buTreeListByParam = orgBuTreeDDomainService.getBuTreeListByParam(param);
        return OrgTreeConvert.INSTANCE.treeDtoToVo(buTreeListByParam);
    }

    /**
     * 根据param获取 组织树节点版本信息
     *
     * @param param param
     * @return list
     */
    @Override
    @SysCodeProc
    public OrgBuTreeAndTreeDVO getBuTreeDListByParam(OrgBuTreeVListParam param) {
        OrgBuTreeAndTreeDDTO buTreeDListByBuTreeCode = orgBuTreeDDomainService.getBuTreeDListByBuTreeCode(param);
        return OrgTreeConvert.INSTANCE.dtoToVo(buTreeDListByBuTreeCode);
    }

    /**
     * 发布组织树版本
     *
     * @param id 组织树id
     */
    @Override
    public void releaseBuTreeVersion(Long id) {
        orgBuTreeDDomainService.releaseBuTreeVersion(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<String> buTreeNodeSaveEmployee(BuTreeNodeEmployeeParam param) {
        orgBuTreeEmployeeDoRepo.deleteByBuIdAndBuTreeId(param.getBuId(), param.getBuTreeId());
        List<OrgBuTreeEmployeeDO> buTreeEmployee = new ArrayList<>();
        for (Long aLong : param.getEmployeeId()) {
            OrgBuTreeEmployeeDO orgBuTreeEmployeeDo = new OrgBuTreeEmployeeDO();
            orgBuTreeEmployeeDo.setBuTreeId(param.getBuTreeId());
            orgBuTreeEmployeeDo.setBuId(param.getBuId());
            orgBuTreeEmployeeDo.setBuCode(param.getBuCode());
            orgBuTreeEmployeeDo.setEmployeeId(aLong);
            buTreeEmployee.add(orgBuTreeEmployeeDo);
        }
        orgBuTreeEmployeeDoRepo.saveAll(buTreeEmployee);
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<String> buTreeNodeDeleteEmployee(BuTreeNodeDeleteEmployeeParam param) {
        QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
        Predicate predicate = JpaPredicateBuilder.builder()
                .and(qdo.buId::eq, param.getBuId())
                .and(qdo.buTreeId::eq, param.getBuTreeId())
                .and(qdo.employeeId::in, param.getEmployeeId())
                .getPredicate();

        orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> {
            orgBuTreeEmployeeDoRepo.delete(orgBuTreeEmployeeDO);
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<EmployeePagedRespVO>> buTreeNodeQueryEmployee(BuTreeNodeQueryEmployeeParam param) {
        Assert.notNull(param.getBuTreeId(), "树ID为空");
        Assert.notNull(param.getBuId(), "BuId为空");

        var employeeIds = multiOrgTreeRepoProc.queryBoundEmployeeIds(param);
        if (employeeIds.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }

        var employeeList = employeeRepoProc.listMngOfPage(employeeIds);
        employeeMngService.fillPage(employeeList, null, null);

        return ApiResult.ok(employeeList);
    }

    @Override
    @Transactional
    public ApiResult<String> buTreeNodeAddEmployee(BuTreeNodeEmployeeParam param) {
        QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;

        Predicate predicate = JpaPredicateBuilder.builder()
                .and(qdo.buId::eq, param.getBuId())
                .and(qdo.buTreeId::eq, param.getBuTreeId())
                .and(qdo.employeeId::in, param.getEmployeeId())
                .getPredicate();

        List<Long> orgBuTreeEmployeeDOS = new ArrayList<>();
        orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> {
            orgBuTreeEmployeeDOS.add(orgBuTreeEmployeeDO.getEmployeeId());
        });
        List<OrgBuTreeEmployeeDO> buTreeEmployee = new ArrayList<>();
        for (Long aLong : param.getEmployeeId()) {
            if (orgBuTreeEmployeeDOS.contains(aLong)) {
                return ApiResult.fail("员工已绑定:" + aLong);
            }
            OrgBuTreeEmployeeDO orgBuTreeEmployeeDo = new OrgBuTreeEmployeeDO();
            orgBuTreeEmployeeDo.setBuTreeId(param.getBuTreeId());
            orgBuTreeEmployeeDo.setBuId(param.getBuId());
            orgBuTreeEmployeeDo.setBuCode(param.getBuCode());
            orgBuTreeEmployeeDo.setEmployeeId(aLong);
            buTreeEmployee.add(orgBuTreeEmployeeDo);
        }
        orgBuTreeEmployeeDoRepo.saveAll(buTreeEmployee);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<EmpOrgTreeOrgDTO>> searchOrgByOrgTreeCodeAndEmpId(com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam param) {
//        QOrgBuTreeDO qOrgBuTreeDO=    QOrgBuTreeDO.orgBuTreeDO;
        //查询组织树信息
        OrgBuTreeDO orgBuTreeDO=  orgBuTreeService.getOrgBuTreeDetailByCode(param.getOrgTreeCode());
        if(orgBuTreeDO==null){
            return ApiResult.fail("沒有找到对应的编码组织树"+param.getOrgTreeCode());
        }else{
            QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
            Predicate predicate = JpaPredicateBuilder.builder()
                    .and(qdo.buTreeId::eq, orgBuTreeDO.getId())
                    .and(qdo.employeeId::eq, param.getEmpId())
                    .getPredicate();
            List<OrgBuTreeEmployeeDO> orgBuTreeEmployeeDOS = new ArrayList<>();
            //获取当前员工ID在所在组织树中的组织数据
            orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> {
                orgBuTreeEmployeeDOS.add(orgBuTreeEmployeeDO);
            });
            if(orgBuTreeEmployeeDOS.size()==0){
                return ApiResult.fail("当组织树（"+param.getOrgTreeCode()+"）和员工("+param.getEmpId()+")没有找到员工所在组织数据");
            }else {
                //查询全部的组织树数据，采用树形
                ApiResult<List<OrgTreeNodeRespVO>> apiResult =
                        multiOrgTreeQueryService.getTree(orgBuTreeDO.getId(), true, false, true);

                if(!apiResult.isSuccess()){
                    return ApiResult.fail(apiResult.getErrorMsg());
                }else{
                    List<EmpOrgTreeOrgDTO> empOrgTreeOrgVos=new ArrayList<>();
                    List<OrgTreeNodeRespVO> data=apiResult.getData();
                    if(data==null||data.size()==0){
                        return ApiResult.ok();
                    }if(data.size()>1){
                        return ApiResult.fail("数据异常，组织树有多个根节点（编码"+param.getOrgTreeCode()
                                +" ID"+orgBuTreeDO.getId()+" 名称"+orgBuTreeDO.getBuTreeName()+")");
                    }else{
                        OrgTreeNodeRespVO orgTreeNodeRespVO=   data.get(0);
                        for (OrgBuTreeEmployeeDO orgBuTreeEmployeeDO : orgBuTreeEmployeeDOS) {
                            EmpOrgTreeOrgDTO empOrgTreeOrgVo=new EmpOrgTreeOrgDTO();
                            empOrgTreeOrgVo.setEmpId(param.getEmpId());
                            empOrgTreeOrgVo.setBuTreeId(orgBuTreeDO.getId());
                            empOrgTreeOrgVo.setBuTreeType(orgBuTreeDO.getBuTreeType());
                            empOrgTreeOrgVo.setBuTreeCode(orgBuTreeDO.getBuTreeCode());
                            empOrgTreeOrgVo.setBuTreeName(orgBuTreeDO.getBuTreeName());
                            empOrgTreeOrgVo.setNowVersion(orgBuTreeDO.getNowVersion());

                            //递归获取当前组织树中组织的对象，包含全部下级
                            OrgTreeNodeRespVO presentTreeNodeRespVO=
                                    findNodeById(orgTreeNodeRespVO,orgBuTreeEmployeeDO.getBuId());

                            empOrgTreeOrgVo.setOrgTreeNodeRespVO(presentTreeNodeRespVO);
                            empOrgTreeOrgVos.add(empOrgTreeOrgVo);
                        }
                        return ApiResult.ok(empOrgTreeOrgVos);
                    }
                }
            }
        }
    }
    public static OrgTreeNodeRespVO findNodeById(OrgTreeNodeRespVO root, Long targetId) {
        // 检查根节点的code是否匹配
        if (root.getId().equals(targetId)) {
            return root; // 找到匹配的节点，直接返回
        }
        // 如果没有子节点或者子节点列表为空，则直接返回null
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return null;
        }
        // 遍历子节点进行递归搜索
        for (OrgTreeNodeRespVO child : root.getChildren()) {
            OrgTreeNodeRespVO found = findNodeById(child, targetId); // 递归调用
            if (found != null) {
                return found; // 如果在子节点中找到匹配的节点，返回该节点
            }
        }
        // 如果没有找到匹配的节点，返回null
        return null;
    }
    // 递归搜索方法
    public static OrgTreeNodeRespVO findNodeByCode(OrgTreeNodeRespVO root, String targetCode) {
        // 检查根节点的code是否匹配
        if (root.getCode().equals(targetCode)) {
            return root; // 找到匹配的节点，直接返回
        }
        // 如果没有子节点或者子节点列表为空，则直接返回null
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return null;
        }
        // 遍历子节点进行递归搜索
        for (OrgTreeNodeRespVO child : root.getChildren()) {
            OrgTreeNodeRespVO found = findNodeByCode(child, targetCode); // 递归调用
            if (found != null) {
                return found; // 如果在子节点中找到匹配的节点，返回该节点
            }
        }
        // 如果没有找到匹配的节点，返回null
        return null;
    }
}
