package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.common.OrgBuTreeStatus;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeQueryEmployeeParam;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/7
 */
@Repository
public class MultiOrgTreeRepoProc extends BaseRepoProc<OrgBuTreeDO> {
    private static final QOrgBuTreeDO QDO = QOrgBuTreeDO.orgBuTreeDO;
    private static final QOrgBuTreeDDO QDO_D = QOrgBuTreeDDO.orgBuTreeDDO;
    private static final QOrgBuTreeEmployeeDO QDO_TREE_EMP = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;
    private static final QSysEmployeeDO QDO_EMP = QSysEmployeeDO.sysEmployeeDO;

    public MultiOrgTreeRepoProc() {
        super(QDO);
    }

    /**
     * 获取树列表
     *
     * @return
     */
    public List<IdCodeNameParam> queryListTree() {
        var qBean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.buTreeCode.as("code"), QDO.buTreeName.as("name"));
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.buTreeStatus, OrgBuTreeStatus.ACTIVE.getValue())
                .build();

        return jpaQueryFactory.select(qBean)
                .from(QDO)
                .where(predicate)
                .orderBy(defaultOrder())
                .fetch();
    }

    /**
     * 查询树信息
     *
     * @param treeId
     * @return
     */
    public List<OrgTreeNodeRespVO> queryTreeLeaf(long treeId) {
        var qBean = Projections.bean(OrgTreeNodeRespVO.class, QDO_D.id, QDO_D.pid.as("parentId"), QDO_D.sortNo, QDO_D.buId.as("tempId"));
        return jpaQueryFactory.select(qBean)
                .from(QDO_D)
                .where(QDO_D.buTreeId.eq(treeId))
                .fetch();
    }

    public List<Long> queryBoundEmployeeIds(BuTreeNodeQueryEmployeeParam param) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO_TREE_EMP.buTreeId, param.getBuTreeId())
                .andEq(QDO_TREE_EMP.buId, param.getBuId())
                .and(true, () -> JPAExpressions.select(QDO_EMP.id).from(QDO_EMP).where(QDO_EMP.id.eq(QDO_TREE_EMP.employeeId)).exists())
                .build();

        return super.jpaQueryFactory.select(QDO_TREE_EMP.employeeId)
                .from(QDO_TREE_EMP)
                .where(predicate)
                .fetch();
    }

    public List<SysEmployeeBasicDTO> queryBoundEmployee(long treeId) {
        return jpaQueryFactory.select(qBeanEmployeeBasicDTO())
                .from(QDO_EMP)
                .leftJoin(QDO_TREE_EMP).on(QDO_TREE_EMP.employeeId.eq(QDO_EMP.id))
                .where(QDO_TREE_EMP.buTreeId.eq(treeId))
                .fetch();
    }

    public void deleteEmployeeOfTree(long treeId) {
        super.jpaQueryFactory.delete(QDO_TREE_EMP)
                .where(QDO_TREE_EMP.buTreeId.eq(treeId))
                .execute();
    }

    private OrderSpecifier<?> defaultOrder() {
        return QDO.createTime.asc();
    }

    private QBean<SysEmployeeBasicDTO> qBeanEmployeeBasicDTO() {
        return Projections.bean(SysEmployeeBasicDTO.class, QDO_EMP.id, QDO_EMP.userId, QDO_EMP.rootOrgId, QDO_EMP.lastName, QDO_EMP.firstName,
                QDO_EMP.gender, QDO_EMP.code, QDO_EMP.email, QDO_EMP.phone, QDO_EMP.type, QDO_EMP.served, QDO_EMP.photo, QDO_EMP.enabled, QDO_EMP.sortNo,
                QDO_TREE_EMP.buId.as("orgId"));
    }
}
