package com.elitescloud.cloudt.system.modules.warning.common;

/**
 * 条件值操作类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
public enum SysWarningOprEnum {
    EQ("等于"),
    NE("不等于"),
    GT("大于"),
    GE("大于等于"),
    LT("小于"),
    LE("小于等于"),
    CONTAINS("包含"),
    NOT_CONTAINS("不包含"),
    BETWEEN("介于"),
    ;

    private final String description;

    SysWarningOprEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static SysWarningOprEnum getByValue(String value) {
        for (SysWarningOprEnum sysWarningOprEnum : SysWarningOprEnum.values()) {
            if (sysWarningOprEnum.name().equals(value)) {
                return sysWarningOprEnum;
            }
        }

        return null;
    }
}
