package com.elitescloud.cloudt.system.modules.warning.provider;

import com.elitescloud.boot.util.JSONUtil;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 预警任务.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/9 周四
 */
public class SysWarningJob implements Job {
    private static final Logger logger = LoggerFactory.getLogger(SysWarningJob.class);

    public static final String JOB_DATA_RULE_ID = "ruleId";
    public static final String JOB_DATA_RULE_CODE = "ruleCode";

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.info("预警任务：{}", context.getJobDetail().getKey());

        JobDataMap jobDataMap = context.getMergedJobDataMap();
        logger.info("任务参数：{}", JSONUtil.toJsonString(jobDataMap));
    }
}
