package com.elitescloud.cloudt.system.modules.warning.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;

import java.time.LocalTime;
import java.util.*;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
abstract class AbstractSysWarningService {
    private static final Map<String, Integer> WEEK_MAP = new HashMap<>();
    private static final Map<String, Integer> MONTH_MAP = new HashMap<>();

    static {
        WEEK_MAP.put("一", 1);
        WEEK_MAP.put("二", 2);
        WEEK_MAP.put("三", 3);
        WEEK_MAP.put("四", 4);
        WEEK_MAP.put("五", 5);
        WEEK_MAP.put("六", 6);
        WEEK_MAP.put("日", 7);

        MONTH_MAP.put("一", 1);
        MONTH_MAP.put("二", 2);
        MONTH_MAP.put("三", 3);
        MONTH_MAP.put("四", 4);
        MONTH_MAP.put("五", 5);
        MONTH_MAP.put("六", 6);
        MONTH_MAP.put("七", 7);
        MONTH_MAP.put("八", 8);
        MONTH_MAP.put("九", 9);
        MONTH_MAP.put("十", 10);
        MONTH_MAP.put("十一", 11);
        MONTH_MAP.put("十二", 12);
        MONTH_MAP.put("十三", 13);
        MONTH_MAP.put("十四", 14);
        MONTH_MAP.put("十五", 15);
        MONTH_MAP.put("十六", 16);
        MONTH_MAP.put("十七", 17);
        MONTH_MAP.put("十八", 18);
        MONTH_MAP.put("十九", 19);
        MONTH_MAP.put("二十", 20);
        MONTH_MAP.put("二十一", 21);
        MONTH_MAP.put("二十二", 22);
        MONTH_MAP.put("二十三", 23);
        MONTH_MAP.put("二十四", 24);
        MONTH_MAP.put("二十五", 25);
        MONTH_MAP.put("二十六", 26);
        MONTH_MAP.put("二十七", 27);
        MONTH_MAP.put("二十八", 28);
        MONTH_MAP.put("二十九", 29);
        MONTH_MAP.put("三十", 30);
        MONTH_MAP.put("三十一", 31);
    }

    /**
     * 获取星期
     *
     * @param userInput
     * @return
     */
    protected int obtainDayOfWeek(String userInput) {
        if (userInput.startsWith("星期")) {
            userInput = userInput.substring(2);
        } else if (userInput.startsWith("周")) {
            userInput = userInput.substring(1);
        }

        if (WEEK_MAP.containsKey(userInput)) {
            return WEEK_MAP.get(userInput);
        }

        int week = Integer.parseInt(userInput);
        if (week >= 1 && week <= 7) {
            return week;
        }
        throw new IllegalArgumentException("星期的取值范围为1-7");
    }

    /**
     * 获取月中的日
     *
     * @param userInput
     * @return
     */
    protected int obtainDayOfMonth(String userInput) {
        if (userInput.endsWith("日")) {
            userInput = userInput.substring(0, userInput.length() - 1);
        } else if (userInput.startsWith("号")) {
            userInput = userInput.substring(0, userInput.length() - 1);
        }

        if (MONTH_MAP.containsKey(userInput)) {
            return MONTH_MAP.get(userInput);
        }

        int week = Integer.parseInt(userInput);
        if (week >= 1 && week <= 31) {
            return week;
        }
        throw new IllegalArgumentException("日取值范围为1-31");
    }

    protected String convertPrettyExecType(SysWarningTimeEnum execTimeType, String execTypeValues, LocalTime execStartTime) {
        if (execTimeType == null) {
            return null;
        }

        switch (execTimeType) {
            case DAY:
                return "每日 " + DatetimeUtil.toStr(execStartTime);
            case WEEK:
                if (StrUtil.isBlank(execTypeValues)) {
                    return null;
                }

                String[] valuesWeek = Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : WEEK_MAP.entrySet()) {
                        if (entry.getValue().toString().equals(t)) {
                            return entry.getKey();
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(String[]::new);
                if (valuesWeek.length == 0) {
                    return null;
                }
                if (valuesWeek.length == 1) {
                    return "每周" + valuesWeek[0] + DatetimeUtil.toStr(execStartTime);
                }

                return "每周(" + String.join("、", valuesWeek) + ")"  + DatetimeUtil.toStr(execStartTime);
            case MONTH:
                if (StrUtil.isBlank(execTypeValues)) {
                    return null;
                }

                String[] valuesMonth = Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : MONTH_MAP.entrySet()) {
                        if (entry.getValue().toString().equals(t)) {
                            return entry.getValue() + "日";
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(String[]::new);
                if (valuesMonth.length == 0) {
                    return null;
                }
                if (valuesMonth.length == 1) {
                    return "每月" + valuesMonth[0] + " " + DatetimeUtil.toStr(execStartTime);
                }

                return "每月(" + String.join("、", execTypeValues) + ")" + " "  + DatetimeUtil.toStr(execStartTime);
            case CUSTOM:
                if (StrUtil.isBlank(execTypeValues)) {
                    return null;
                }

                var valuesCustom = execTypeValues.split(",");
                if (valuesCustom.length == 2) {
                    return "自定义(" + valuesCustom[0] + "至" + valuesCustom[1] + ") " + DatetimeUtil.toStr(execStartTime);
                }
                return null;
            default:
                return null;
        }
    }

    protected List<String> convertExecType(SysWarningTimeEnum execTimeType, String execTypeValues) {
        if (execTimeType == null) {
            return null;
        }
        if (StrUtil.isBlank(execTypeValues)) {
            return Collections.emptyList();
        }

        switch (execTimeType) {
            case DAY:
                return Collections.emptyList();
            case WEEK:
                return Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : WEEK_MAP.entrySet()) {
                        if (entry.getValue().toString().equals(t)) {
                            return entry.getKey();
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
            case MONTH:
                if (StrUtil.isBlank(execTypeValues)) {
                    return null;
                }

                return Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : MONTH_MAP.entrySet()) {
                        if (entry.getValue().toString().equals(t)) {
                            return entry.getValue() + "";
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
            case CUSTOM:
                if (StrUtil.isBlank(execTypeValues)) {
                    return null;
                }

                return Arrays.stream(execTypeValues.split(",")).toList();
            default:
                return null;
        }
    }
}
