package com.elitescloud.cloudt.system.modules.warning.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRecordNoticeDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordNoticeDO;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@Repository
public class SysWarningNoticeRepoProc extends BaseRepoProc<SysWarningRecordNoticeDO> {
    private static final QSysWarningRecordNoticeDO QDO = QSysWarningRecordNoticeDO.sysWarningRecordNoticeDO;

    public SysWarningNoticeRepoProc() {
        super(QDO);
    }

    public Map<Long, List<SysWarningRecordNoticeDO>> listByDetailId(Collection<Long> detailIds) {
        return super.getList(QDO.masId.in(detailIds)).stream()
                .collect(Collectors.groupingBy(SysWarningRecordNoticeDO::getMasId));
    }
}
