package com.elitescloud.cloudt.system.modules.warning.web.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.service.SysWarningRuleMngService;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRulePageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRuleDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRulePageRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.save.SysWarningRuleSaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@RestController
@RequestMapping(value = "/mng/warning/rule")
@Api(tags = "预警规则")
public class SysWarningRuleMngController {

    @Autowired
    private SysWarningRuleMngService sysWarningRuleMngService;

    @ApiOperation(value = "保存规则")
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid SysWarningRuleSaveVO saveVO) {
        return sysWarningRuleMngService.save(saveVO);
    }

    @ApiOperation(value = "分页查询规则")
    @PostMapping(value = "/pageMng")
    public ApiResult<PagingVO<SysWarningRulePageRespVO>> pageMng(@RequestBody SysWarningRulePageQueryVO queryVO) {
        return sysWarningRuleMngService.pageMng(queryVO);
    }

    @ApiOperation(value = "批量更新为启用")
    @PostMapping(value = "/updateEnabled")
    public ApiResult<List<Long>> updateEnabled(@RequestBody List<Long> ids) {
        return sysWarningRuleMngService.updateEnabled(ids, true);
    }

    @ApiOperation(value = "批量更新为禁用")
    @PostMapping(value = "/updateDisabled")
    public ApiResult<List<Long>> updateDisabled(@RequestBody List<Long> ids) {
        return sysWarningRuleMngService.updateEnabled(ids, false);
    }

    @ApiOperation(value = "批量删除")
    @PostMapping(value = "/deleteBatch")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        return sysWarningRuleMngService.delete(ids);
    }

    @ApiOperation(value = "根据ID获取规则详情")
    @GetMapping(value = "/detail")
    public ApiResult<SysWarningRuleDetailRespVO> getDetail(@RequestParam(name = "id") Long id) {
        return sysWarningRuleMngService.getDetail(id);
    }

    @ApiOperation(value = "根据ID获取下次执行时间")
    @GetMapping(value = "/nextTriggerTime")
    public ApiResult<List<String>> getNextTriggerTime(@RequestParam(name = "id") Long id) {
        return sysWarningRuleMngService.getNextTriggerTime(id);
    }
}
