package com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningNoticeRateEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningOprEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningRelEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.List;

/**
 * 预警规则详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/5 周二
 */
@Getter
@Setter
@ApiModel(description = "预警规则详细信息")
public class SysWarningRuleDetailRespVO implements Serializable {
    @Serial
    private static final long serialVersionUID = 3299903516884515704L;

    @ApiModelProperty(value = "规则ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "规则编码", position = 2)
    private String ruleCode;

    @ApiModelProperty(value = "规则名称", position = 3)
    private String ruleName;

    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    @ApiModelProperty(value = "规则描述", position = 5)
    private String description;

    @ApiModelProperty(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE", position = 11)
    private String scene;
    private String sceneName;

    @ApiModelProperty(value = "业务规则的条件列表", position = 12)
    @Valid
    private List<SceneCondition> sceneConditionList;

    @ApiModelProperty(value = "执行条件(时间)", position = 13)
    private ExecTime timeCondition;

    @ApiModelProperty(value = "消息通知", position = 14)
    private NoticeMsg notice;

    @Getter
    @Setter
    @ApiModel(description = "预警规则的条件")
    public static class SceneCondition implements Serializable {
        @Serial
        private static final long serialVersionUID = 3375981204505363026L;

        @ApiModelProperty(value = "条件项, [UDC]WARNING_CONDITION", position = 1)
        private String condTerm;
        private String condTermName;

        @ApiModelProperty(value = "条件值", position = 2)
        private SysWarningOprEnum opr;
        private String oprName;

        @ApiModelProperty(value = "数据范围", position = 3)
        private List<String> valueList;

        @ApiModelProperty(value = "条件关联", position = 4)
        private SysWarningRelEnum rel;
        private String relName;
    }

    @Getter
    @Setter
    @ApiModel(description = "执行条件时间")
    public static class ExecTime implements Serializable {
        @Serial
        private static final long serialVersionUID = -5231007355907728319L;

        @ApiModelProperty(value = "执行时间类型", position = 1)
        private SysWarningTimeEnum timeType;
        private String timeTypeName;

        @ApiModelProperty(value = "执行时间值, (周：[一、二、三、四、五、六、日]; 月[1、2、3、4等]; 自定义[yyyy-MM-dd])", position = 2)
        private List<String> valueList;

        @ApiModelProperty(value = "开始时间", position = 3)
        private LocalTime startTime;

        @ApiModelProperty(value = "是否开启工作日免打扰", position = 4)
        private Boolean excludedWorkday;

        @ApiModelProperty(value = "工作日免打扰-开始时间", position = 5)
        private LocalTime workdayStartTime;

        @ApiModelProperty(value = "工作日免打扰-截止时间", position = 6)
        private LocalTime workdayEndTime;

        @ApiModelProperty(value = "是否开启节假日免打扰", position = 7)
        private Boolean excludedHolidays;

        @ApiModelProperty(value = "通知频率", position = 8)
        private SysWarningNoticeRateEnum noticeRate;
        private String noticeRateName;

        @ApiModelProperty(value = "自定义通知频率值(分钟)", position = 9)
        private Integer noticeRateValue;
    }

    @Getter
    @Setter
    @ApiModel(description = "消息通知")
    public static class NoticeMsg implements Serializable {
        @Serial
        private static final long serialVersionUID = 5329606504128016072L;

        @ApiModelProperty(value = "消息模板编码", position = 1)
        private String tmplCode;
        private String tmplName;

        @ApiModelProperty(value = "推送方式", position = 2)
        private List<MsgSendTypeEnum> sendTypeList;
        private List<String> sendTypeNameList;

        @ApiModelProperty(value = "推送对象-按角色", position = 3)
        private Boolean enabledRecvByRole;

        @ApiModelProperty(value = "推送对象-角色编码", position = 4)
        private List<String> recvRoleCodes;
        private List<String> recvRoleNames;

        @ApiModelProperty(value = "推送对象-仅针对预警对象", position = 5)
        private Boolean onlyPushWarningObj;

        @ApiModelProperty(value = "推送对象-按用户", position = 6)
        private Boolean enabledRecvByUser;

        @ApiModelProperty(value = "推送对象-用户ID", position = 7)
        private List<Long> recvUserIds;
        private List<String> recvUserNames;
    }
}
