package com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Getter
@Setter
@ApiModel(description = "预警规则分页查询结果")
public class SysWarningRulePageRespVO implements Serializable {
    @Serial
    private static final long serialVersionUID = 8432374200156925359L;

    @ApiModelProperty(value = "规则ID")
    private Long id;

    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    @ApiModelProperty(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE")
    private String scene;
    private String sceneName;

    @ApiModelProperty(value = "执行时间类型")
    private String execTimeType;
    private String execTimeTypeName;
    @JsonIgnore
    private transient String execTimeValues;
    @JsonIgnore
    private transient LocalTime execStartTime;
    @ApiModelProperty(value = "执行时间")
    private String execTimePretty;

    @ApiModelProperty(value = "通知频率")
    private String noticeRateValue;
    private String noticeRateValueName;

    @JsonIgnore
    private transient String sendTypes;
    @ApiModelProperty(value = "推送方式")
    private List<String> sendTypeList;
    private List<String> sendTypeNameList;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;
}
