package com.elitescloud.cloudt.system.modules.warning.web.model.vo.save;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningNoticeRateEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningOprEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningRelEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.List;

/**
 * 预警规则保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/3 周日
 */
@Getter
@Setter
@ApiModel(description = "预警规则保存参数")
public class SysWarningRuleSaveVO implements Serializable {
    @Serial
    private static final long serialVersionUID = 8097164039403713631L;

    @ApiModelProperty(value = "规则ID，编辑时不可为空", position = 1)
    private Long id;

    @ApiModelProperty(value = "规则编码，为空则自动生成", position = 2)
    private String ruleCode;

    @NotBlank(message = "规则名称不能为空")
    @ApiModelProperty(value = "规则名称", position = 3, required = true)
    private String ruleName;

    @ApiModelProperty(value = "启用状态, 默认禁用", position = 4)
    private Boolean enabled;

    @ApiModelProperty(value = "规则描述", position = 5)
    private String description;

    @NotBlank(message = "业务场景不能为空")
    @ApiModelProperty(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE", position = 11, required = true)
    private String scene;

    @ApiModelProperty(value = "业务规则的条件列表", position = 12)
    @Valid
    private List<SceneCondition> sceneConditionList;

    @NotNull(message = "执行条件不能为空")
    @Valid
    @ApiModelProperty(value = "执行条件(时间)", position = 13, required = true)
    private ExecTime timeCondition;

    @NotNull(message = "消息通知不能为空")
    @Valid
    @ApiModelProperty(value = "消息通知", position = 14, required = true)
    private NoticeMsg notice;

    @Getter
    @Setter
    @ApiModel(description = "预警规则的条件")
    public static class SceneCondition implements Serializable {
        @Serial
        private static final long serialVersionUID = -2638487884080999399L;

        @NotBlank(message = "条件项不能为空")
        @ApiModelProperty(value = "条件项, [UDC]WARNING_CONDITION", required = true, position = 1)
        private String condTerm;

        @NotNull(message = "条件值不能为空")
        @ApiModelProperty(value = "条件值", required = true, position = 2)
        private SysWarningOprEnum opr;

        @ApiModelProperty(value = "数据范围", position = 3)
        private List<String> valueList;

        @NotNull(message = "关联不能为空")
        @ApiModelProperty(value = "条件关联", position = 4, required = true)
        private SysWarningRelEnum rel;
    }

    @Getter
    @Setter
    @ApiModel(description = "执行条件时间")
    public static class ExecTime implements Serializable {
        @Serial
        private static final long serialVersionUID = -3192833762016665969L;

        @NotNull(message = "执行时间类型不能为空")
        @ApiModelProperty(value = "执行时间类型", position = 1, required = true)
        private SysWarningTimeEnum timeType;

        @ApiModelProperty(value = "执行时间值, (周：[一、二、三、四、五、六、日]; 月[1、2、3、4等]; 自定义[yyyy-MM-dd])", position = 2)
        private List<String> valueList;

        @NotNull(message = "开始时间不能为空")
        @ApiModelProperty(value = "开始时间", required = true, position = 3)
        private LocalTime startTime;

        @ApiModelProperty(value = "是否开启工作日免打扰", position = 4)
        private Boolean excludedWorkday;

        @ApiModelProperty(value = "工作日免打扰-开始时间", position = 5)
        private LocalTime workdayStartTime;

        @ApiModelProperty(value = "工作日免打扰-截止时间", position = 6)
        private LocalTime workdayEndTime;

        @ApiModelProperty(value = "是否开启节假日免打扰", position = 7)
        private Boolean excludedHolidays;

        @NotNull(message = "通知频率不能为空")
        @ApiModelProperty(value = "通知频率", required = true, position = 8)
        private SysWarningNoticeRateEnum noticeRate;

        @ApiModelProperty(value = "自定义通知频率值(分钟)", position = 9)
        private Integer noticeRateValue;
    }

    @Getter
    @Setter
    @ApiModel(description = "消息通知")
    public static class NoticeMsg implements Serializable {
        @Serial
        private static final long serialVersionUID = -7197615284902850918L;

        @NotBlank(message = "消息模板编码不能为空")
        @ApiModelProperty(value = "消息模板编码", position = 1, required = true)
        private String tmplCode;

        @NotEmpty(message = "推送方式不能为空")
        @ApiModelProperty(value = "推送方式", position = 2, required = true)
        private List<MsgSendTypeEnum> sendTypeList;

        @ApiModelProperty(value = "推送对象-按角色", position = 3)
        private Boolean enabledRecvByRole;

        @ApiModelProperty(value = "推送对象-角色编码", position = 4)
        private List<String> recvRoleCodes;

        @ApiModelProperty(value = "推送对象-仅针对预警对象", position = 5)
        private Boolean onlyPushWarningObj;

        @ApiModelProperty(value = "推送对象-按用户", position = 6)
        private Boolean enabledRecvByUser;

        @ApiModelProperty(value = "推送对象-用户ID", position = 7)
        private List<Long> recvUserIds;
    }
}
