package com.elitescloud.cloudt.system.modules.wecom.model.msg;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * Markdown消息.
 * <p>
 * <a href="https://developer.work.weixin.qq.com/document/path/90236#markdown%E6%B6%88%E6%81%AF">API文档</a>
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/5 周四
 */
@Getter
@Setter
public class MarkdownMsg extends BaseMsg {
    private static final long serialVersionUID = 3676409998660743490L;

    /**
     * 消息类型
     */
    private final String msgtype = "markdown";

    /**
     * 消息体
     */
    private Markdown markdown;

    @Override
    public String getMsgtype() {
        return msgtype;
    }

    @Getter
    @Setter
    public static class Markdown implements Serializable {
        private static final long serialVersionUID = 925072186758910821L;

        /**
         * 消息内容
         */
        private String content;

        public Markdown() {
        }

        public Markdown(String content) {
            this.content = content;
        }
    }
}
