package com.elitescloud.cloudt.system.modules.wecom.model.msg;

import com.elitescloud.cloudt.system.modules.wecom.model.BaseResult;
import lombok.Getter;
import lombok.Setter;

/**
 * 消息发送结果.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/5 周四
 */
@Getter
@Setter
public class MsgResult extends BaseResult {
    private static final long serialVersionUID = -3773246345252281236L;

    /**
     * 不合法的userid
     * <p>
     * 不区分大小写，统一转为小写, 如userid1|userid2
     */
    private String invaliduser;

    /**
     * 不合法的partyid
     * <p>
     * 如partyid1|partyid2
     */
    private String invalidparty;

    /**
     * 不合法的tagid
     * <p>
     * 如tagid1|tagid2
     */
    private String invalidtag;

    /**
     * 没有基础接口许可(包含已过期)的userid
     * <p>
     * 如external_userid1|external_userid2
     */
    private String unlicenseduser;

    /**
     * 消息id
     */
    private String msgid;

    /**
     * 响应码
     * <p>
     * 仅消息类型为“按钮交互型”，“投票选择型”和“多项选择型”的模板卡片消息返回，应用可使用response_code调用更新模版卡片消息接口，72小时内有效，且只能使用一次
     */
    private String response_code;
}
