package com.elitescloud.cloudt.system.modules.wecom.model.msg;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 文本消息.
 * <p>
 * <a href="https://developer.work.weixin.qq.com/document/path/90236#%E6%96%87%E6%9C%AC%E6%B6%88%E6%81%AF">API文档</a>
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/5 周四
 */
@Getter
@Setter
public class TextMsg extends BaseMsg {
    private static final long serialVersionUID = -9107468211724964823L;

    /**
     * 消息类型
     */
    private final String msgtype = "text";

    /**
     * 消息体
     */
    private Text text;

    @Override
    public String getMsgtype() {
        return msgtype;
    }

    @Getter
    @Setter
    public static class Text implements Serializable {
        private static final long serialVersionUID = 925072186758910821L;

        /**
         * 消息内容
         */
        private String content;

        public Text() {
        }

        public Text(String content) {
            this.content = content;
        }
    }
}
