package com.elitescloud.cloudt.system.modules.xingyunzuo.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.modules.xingyunzuo.service.XingyunzuoService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 星云座接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/26
 */
@Api(tags = "星云座接口")
@RestController
@RequestMapping(value = "/lowcode/xingyunzuo")
@Validated
public class XingyunzuoController {

    @Autowired
    private XingyunzuoService xingyunzuoService;

    @GetMapping(value = "/auth")
    public ApiResult<String> generateToken() {
        return xingyunzuoService.generateToken();
    }
}
