package com.elitescloud.cloudt.system.provider.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.SysPageFiledConfigConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlParam;
import com.elitescloud.cloudt.system.provider.export.param.PageFieldExportBO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 前端配置导出.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/27
 */
@Component
public class PageFieldExportProvider implements DataExport<PageFieldExportBO, SysPageFieldConfigDtlParam> {

    @Autowired
    private SysPageFieldConfigService service;

    @Override
    public String getTmplCode() {
        return "sys_fieldconfig_export";
    }

    @Override
    public PagingVO<PageFieldExportBO> executeExport(SysPageFieldConfigDtlParam queryParam) {
        var pageData = service.queryPageFieldConfigDtl(queryParam).getData();
        if (pageData == null) {
            return PagingVO.empty();
        }
        return pageData.map(t -> {
            var exportBO = SysPageFiledConfigConvert.INSTANCE.voToExportVo(t);
            exportBO.setFieldRequiredName(Boolean.TRUE.equals(t.getFieldRequired()) ? "是" : "否");
            exportBO.setFieldEditName(Boolean.TRUE.equals(t.getFieldEdit()) ? "是" : "否");
            exportBO.setFieldHiddenName(Boolean.TRUE.equals(t.getFieldHidden()) ? "是" : "否");
            return exportBO;
        });
    }
}
