package com.elitescloud.cloudt.system.provider.mq;

import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.mq.config.support.storage.MqMessageQueueStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/24
 */
@Component
@ConditionalOnClass(MessageQueueListener.class)
public class MqRecordLogListener implements MessageQueueListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(MqRecordLogListener.class);

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{MqMessageQueueStorage.CHANNEL};
    }

    @Override
    public void onConsume(@NotBlank String channel, @NotNull String payload) {
        logger.info("接收到MQ消息记录：{}", payload);
    }
}
