package com.elitescloud.cloudt.system.provider.usersync;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 同步结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Getter
@Setter
public class SyncUserResult implements Serializable {
    private static final long serialVersionUID = -1451370857059072842L;

    /**
     * 账号ID
     */
    private Long userId;

    /**
     * 回执信息
     */
    private String receipt;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 失败信息
     */
    private String failMsg;

    /**
     * 外部系统账号ID
     */
    private String outerUserId;

    /**
     * 外部系统用户账号编码
     */
    private String outerUserCode;

    public SyncUserResult() {
    }

    public SyncUserResult(Long userId) {
        this.userId = userId;
    }
}
