package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UnifyQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UnifySqlQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.UnifyQueryRespDTO;
import com.elitescloud.cloudt.system.provider.SysUnifyQueryRpcService;
import com.elitescloud.cloudt.system.service.SysUnifyQueryQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/6
 */
@RestController
@RequestMapping(value = SysUnifyQueryRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUnifyQueryRpcServiceImpl implements SysUnifyQueryRpcService {

    private SysUnifyQueryQueryService sysUnifyQueryService;

    @Override
    public ApiResult<UnifyQueryRespDTO> query(UnifyQueryQueryDTO paramDTO) {
        return sysUnifyQueryService.query(paramDTO);
    }

    @Override
    public ApiResult<UnifyQueryRespDTO> queryBySql(UnifySqlQueryQueryDTO paramDTO) {
        return sysUnifyQueryService.queryBySql(paramDTO);
    }

    @Autowired
    public void setSysUnifyQueryService(SysUnifyQueryQueryService sysUnifyQueryService) {
        this.sysUnifyQueryService = sysUnifyQueryService;
    }
}
