package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.extend.SysBusinessObjectRpcService;
import com.elitescloud.cloudt.system.service.BusinessObjectQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@RestController
@RequestMapping(value = SysBusinessObjectRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysBusinessObjectRpcServiceImpl implements SysBusinessObjectRpcService {

    private BusinessObjectQueryService queryService;

    @Override
    public ApiResult<List<SysBusinessObjectDTO>> allBusinessObject() {
        return queryService.allBusinessObject();
    }

    @Override
    public ApiResult<SysBusinessObjectDTO> getBusinessObjectDetail(String businessObjectCode) {
        return queryService.getBusinessObjectDetail(businessObjectCode);
    }

    @Override
    public ApiResult<List<SysBusinessOperationDTO>> allOperation() {
        return queryService.allOperationDTO();
    }

    @Autowired
    public void setQueryService(BusinessObjectQueryService queryService) {
        this.queryService = queryService;
    }
}
