package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTmplApiRpcService;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.TmplQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@RestController
@RequestMapping(value = SysTmplApiRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@Slf4j
public class SysTmplApiRpcServiceImpl implements SysTmplApiRpcService {

    private TmplQueryService tmplQueryService;
    private TmplImportRecordService recordService;


    @Override
    public ApiResult<SysTmplDTO> getByCode(String code) {
        return tmplQueryService.getByCode(code);
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadByCode(String code) {
        return tmplQueryService.downloadByCode(code);
    }

    @Override
    public ApiResult<FileByteVO> getTmplFileByCode(String code) {
        return tmplQueryService.getTmplFileByCode(code);
    }

    @Override
    public ApiResult<String> getFileCodeByCode(String code) {
        return tmplQueryService.getFileCodeByCode(code);
    }

    @Override
    public ApiResult<Long> saveRecord(String code, String recordFileCode, Map<String, Object> queryParam) {
        return recordService.saveImportRecord(code, recordFileCode, queryParam);
    }

    @Override
    public ApiResult<Long> updateNumTotal(Long recordId, Long numTotal) {
        return recordService.updateRecordTotal(recordId, numTotal);
    }

    @Override
    public ApiResult<Long> updateResult(RecordResultSaveDTO resultDTO) {
        return recordService.updateImportResult(resultDTO);
    }

    @Override
    public ApiResult<SysImportRateDTO> getImportRate(Long recordId) {
        return recordService.getImportRateDto(recordId);
    }

    @Override
    public ApiResult<String> getRecordFileCode(Long recordId) {
        return recordService.getFileCode(recordId);
    }

    @Override
    public ApiResult<List<Long>> queryUnFinished() {
        return recordService.queryUnFinished(null);
    }

    @Override
    public ApiResult<List<Long>> queryUnFinished(String appCode) {
        return recordService.queryUnFinished(appCode);
    }

    @Override
    public ApiResult<Boolean> updateResultForSysError(String appCode, String failMsg) {
        return recordService.updateResultForSysError(appCode, failMsg);
    }

    @Override
    public ApiResult<Long> saveExportFile(Long recordId, String fileCode, Integer order) {
        return recordService.saveExportFile(recordId, fileCode, order);
    }

    @Override
    public ApiResult<Long> saveImportFailRecord(Long recordId, String failFileCode) {
        return recordService.saveImportFailRecord(recordId, failFileCode);
    }

    @Override
    public ApiResult<List<ImportRecordDTO>> queryRecord(String tmplCode, Integer hours, Boolean self) {
        return recordService.queryRecord(tmplCode, hours, self);
    }

    @Autowired
    public void setTmplQueryService(TmplQueryService tmplQueryService) {
        this.tmplQueryService = tmplQueryService;
    }

    @Autowired
    public void setRecordService(TmplImportRecordService recordService) {
        this.recordService = recordService;
    }
}
