package com.elitescloud.cloudt.system.rpc.org;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgDetailRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.service.OrgMngService;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@RestController
@RequestMapping(value = OrgRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class OrgRpcServiceImpl implements OrgRpcService {

    private OrgQueryService queryService;
    private OrgMngService mngService;

    @Override
    public ApiResult<Long> upsert(OrgUpsertDTO upsertDTO) {
        return mngService.upsert(upsertDTO);
    }

    @Override
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        return mngService.updateEnabled(id, enabled);
    }

    @Override
    public ApiResult<Boolean> rebuildtree(Long rootId) {
        return mngService.updateTreeRebuild(rootId);
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        return mngService.delete(id);
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getById(Long id) {
        return queryService.getById(id);
    }

    @Override
    public ApiResult<SysOrgDetailRespDTO> getDetailById(Long id, String withParentType) {
        return queryService.getDetailById(id, withParentType);
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getByCode(String code) {
        return queryService.getByCode(code);
    }

    @Override
    public ApiResult<SysOrgDetailRespDTO> getDetailByCode(String code, String withParentType) {
        return queryService.getDetailByCode(code, withParentType);
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getParentByCode(String code, String parentType) {
        return queryService.getParentByCode(code, parentType);
    }

    @Override
    public ApiResult<Map<String, SysOrgBasicDTO>> getParentByCode(Set<String> codes, String parentType) {
        return queryService.getParentByCode(codes, parentType);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryChildren(String code) {
        return queryService.queryChildren(code);
    }

    @Override
    public ApiResult<Map<String, List<IdCodeNameParam>>> queryChildrenList(Set<String> codes) {
        return queryService.queryChildrenList(codes);
    }

    @Override
    public ApiResult<List<SysOrgBasicDTO>> queryList(SysOrgQueryDTO queryDTO) {
        return queryService.queryList(queryDTO);
    }

    @Override
    public ApiResult<PagingVO<SysOrgPageRespDTO>> queryPage(SysOrgPageQueryDTO queryDTO) {
        return queryService.queryPage(queryDTO);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryCodeAndName(Set<Long> ids) {
        return queryService.queryCodeAndName(ids);
    }

    @Override
    public ApiResult<IdCodeNameParam> getCodeAndName(Long id) {
        var result = queryService.queryCodeAndName(Set.of(id));
        if (result.isFailed()) {
            return ApiResult.fail(result.getMsg());
        }

        return ApiResult.ok(CollUtil.isEmpty(result.getData()) ? null : result.getData().get(0));
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryIdAndName(Set<String> codes) {
        return queryService.queryIdAndName(codes);
    }

    @Override
    public ApiResult<IdCodeNameParam> getIdAndName(String code) {
        var result = queryService.queryIdAndName(Set.of(code));
        if (result.isFailed()) {
            return ApiResult.fail(result.getMsg());
        }

        return ApiResult.ok(CollUtil.isEmpty(result.getData()) ? null : result.getData().get(0));
    }

    @Autowired
    public void setOrgQueryService(OrgQueryService queryService) {
        this.queryService = queryService;
    }

    @Autowired
    public void setOrgMngService(OrgMngService mngService) {
        this.mngService = mngService;
    }
}
