package com.elitescloud.cloudt.system.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.common.EnumValues;
//import com.elitesland.cbpl.unicom.annotation.UnicomTag;
//import com.elitesland.cbpl.unicom.domain.InvokeTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 14:12
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
//@UnicomTag(InvokeTag.TAG_GENERAL)
public class AuthMethodServiceImpl implements AuthMethodService {
    @Override
    public List<EnumValues> authMethod() {
        return Arrays.stream(AuthMethod.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
    }

    @Override
    public Map<String, String> fromCode(List<String> authMethodCodes) {
        Map<String, String> authMethodNames = new HashMap<>();
        if (CollUtil.isEmpty(authMethodCodes)) {
            return authMethodNames;
        }
        for (String authMethodCode : authMethodCodes) {
            authMethodNames.put(authMethodCode, AuthMethod.fromCode(authMethodCode));
        }
        return authMethodNames;
    }
}
