package com.elitescloud.cloudt.system.service;

import cn.hutool.core.text.StrPool;
import com.elitescloud.cloudt.system.model.vo.BotRequest;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.util.DateUtils;
import com.elitescloud.cloudt.system.util.SnsBotUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:28
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BotMessageCustomBuilder implements BotMessageBuilder {
    @Override
    public String templateBuilder(BotRequest request) {
        // 接口调用告警
        if (request.getExtObj() instanceof InfinityLogVO) {
            InfinityLogVO logVO = (InfinityLogVO) request.getExtObj();
            // 标题
            request.setSnsTitle(logVO.getBusinessTypeName() + "(" + logVO.getBusinessType() + ")");
            String requestSuccess = logVO.getRequestSuccess() ? "成功" : "失败";
            String responseSuccess = logVO.getResponseSuccess() ? "成功" : "失败";
            return "> 外部系统：" + logVO.getTargetApp() + StrPool.LF +
                    "> 接口地址：" + logVO.getUri() + StrPool.LF +
                    "> 时间：" + logVO.getRequestTime() + StrPool.LF +
                    "> TraceID：" + logVO.getTraceId() + StrPool.LF +
                    "> 是否请求成功：" + requestSuccess + StrPool.LF +
                    "> 是否响应成功：" + responseSuccess + StrPool.LF +
                    "> 异常信息：" + SnsBotUtil.concat(request.getMessages());
        }
        // 其他
        return "> 调用方式：" + request.getSnsMode() + StrPool.LF +
                "> 异常类型：<font color='red'>" + request.getSnsType() + "</font>" + StrPool.LF +
                "> 异常单据类型：" + request.getSnsScene() + StrPool.LF +
                "> 时间：" + DateUtils.nowStr() + StrPool.LF +
                "> 异常信息：" + SnsBotUtil.concat(request.getMessages());
    }
}
