package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.extend.FrontTableCfgSaveVO;

import javax.validation.constraints.NotBlank;

/**
 * 前端表格配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/20
 */
public interface FrontTableCfgService {

    /**
     * 保存配置
     *
     * @param saveVO 配置信息
     * @param global 是否全局配置，false表示是个人配置
     * @return 保存结果
     */
    ApiResult<Boolean> saveCfg(FrontTableCfgSaveVO saveVO, boolean global);

    /**
     * 获取配置
     *
     * @param tableCode 表格编码
     * @param global    是否全局配置，false表示是个人配置
     * @return 配置内容
     */
    ApiResult<String> getCfg(@NotBlank String tableCode, boolean global);

    /**
     * 获取当前登录用户配置
     *
     * @param tableCode 表格编码
     * @return 配置内容
     */
    ApiResult<String> getUserCfg(@NotBlank String tableCode);
}
