package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageQueryRespVO;
import org.springframework.http.HttpEntity;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/20/2023
 */
public interface TmplQueryService {

    /**
     * 查询模板信息
     *
     * @param queryParam 查询参数
     * @return 模板列表
     */
    ApiResult<PagingVO<TmplPageQueryRespVO>> search(TmplQueryParam queryParam);

    /**
     * 根据模板编号查询模板信息
     *
     * @param code 模板编号
     * @return 模板信息
     */
    ApiResult<SysTmplDTO> getByCode(String code);

    /**
     * 根据模板编号获取模板文件的编码
     *
     * @param code 模板编号
     * @return 模板文件的编码
     */
    ApiResult<String> getFileCodeByCode(String code);

    /**
     * 下载模板
     *
     * @param fileCode 模板文件的唯一标识
     * @return 模板文件
     */
    HttpEntity<StreamingResponseBody> downloadByFileCode(String fileCode);

    /**
     * 下载模板
     *
     * @param code 模板编码
     * @return 模板文件
     */
    HttpEntity<StreamingResponseBody> downloadByCode(String code);

    /**
     * 获取模板文件信息
     *
     * @param code 模板编码
     * @return 文件信息
     */
    ApiResult<FileByteVO> getTmplFileByCode(String code);
}
