package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.model.vo.AuditLogVO;
import com.elitescloud.cloudt.system.service.AuditLogListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:24
 * @Description:
 */
@Slf4j
@Service
public class AuditLogListenerService implements AuditLogListener {
    @Override
    public String getOperatorId() throws Exception {
        Long userId = SecurityContextUtil.currentUserId();
        return ObjectUtil.isNull(userId) ? "" : userId.toString();
    }

    @Override
    public String getOperatorName() throws Exception {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        return ObjectUtil.isNull(user) ? "" : user.getUser().getLastName();
    }

    @Override
    public boolean createLog(AuditLogVO auditLogVO) throws Exception {
        // do nothing.
        return true;
    }

    @Override
    public void operationLogGetErrorHandler() {
        // do nothing.
        log.error("operation log get service error reached max retryTimes!");
    }

    @Override
    public void pipelineErrorHandler() {
        // do nothing.
        log.error("pipeline send log error reached max retryTimes!");
    }
}
