package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticeRespVO;
import com.elitescloud.cloudt.system.service.CommonQueryService;
import com.elitescloud.cloudt.system.service.NoticeQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Service
@Slf4j
public class CommonQueryServiceImpl extends BaseServiceImpl implements CommonQueryService {

    @Autowired
    private NoticeQueryService noticeQueryService;

    @Override
    public ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublishedNotice(CommonPublishedNoticePageQueryVO queryVO) {
        return Boolean.TRUE.equals(queryVO.getSys()) ? noticeQueryService.pageQueryPublishedSys(queryVO) : noticeQueryService.pageQueryPublished(queryVO);
    }

    @Override
    public ApiResult<CommonPublishedNoticeRespVO> viewPublishedNotice(Long id) {
        return noticeQueryService.viewPublishedNotice(id);
    }
}
