package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.common.InfinityWebProperties;
import com.elitescloud.cloudt.system.common.OAuth2Client;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.service.SecurityAuthService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:45
 * @Description:
 */
@Slf4j
@Service
//@UnicomTag("OAUTH_2.0")
public class OAuth2SecurityService implements SecurityAuthService {
    @Autowired(required = false)
    @Lazy
    private OAuth2Client authClient;

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        log.info("[BPMN][INFINITY] 认证方式: " + AuthMethod.AUTH_METHOD_OAUTH_V2.getDesc());
        if (!InfinityWebProperties.INFINITY_WEB_ENABLED) {
            log.error("[BPMN][INFINITY] WebClient not enabled.");
            throw new RuntimeException("WebClient not enabled.");
        }
        OAuth2AccountVO account = param.getApiConfig().getOauth2Account();
        if (ObjectUtil.isNull(account) || account.isEmpty()) {
            log.error("[BPMN][INFINITY] 未维护认证账号.");
            throw new RuntimeException("account is empty.");
        }
        String accessToken = authClient.getAccessToken(param.getPlatformCode(),
                account.getUrl(), account.getClientId(), account.getClientSecret());
        if (StrUtil.isBlank(accessToken)) {
            log.error("[BPMN][INFINITY] token为空.");
            return false;
        }
        uri.header(HttpHeaders.AUTHORIZATION, "Bearer " + accessToken);
        return true;
    }

    @Override
    public String getAuthType() {
        return AuthMethod.AUTH_METHOD_OAUTH_V2.getCode();
    }
}
