package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.SysOuType;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.convert.OuConvert;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonCompanyPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuPageRespVO;
import com.elitescloud.cloudt.system.service.OuQueryService;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
public class OuQueryServiceImpl extends BaseServiceImpl implements OuQueryService {
    private static final OuConvert CONVERT = OuConvert.INSTANCE;

    @Autowired
    private OuRepoProc repoProc;

    @Override
    public ApiResult<PagingVO<OuPageRespVO>> pageQuery(CommonCompanyPageQueryVO queryVO) {
        // 查询数据
        var pageData = repoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData.map(CONVERT::do2PageRespVO));
        }

        // 格式转换
        var ouTypeNames = super.udcMap(new SysOuType());
        var result = pageData.map(t -> {
            var vo = CONVERT.do2PageRespVO(t);
            vo.setOuTypeName(ouTypeNames.get(t.getOuType()));
            return vo;
        });
        return ApiResult.ok(result);
    }
}
