package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.support.common.param.SysVersionUploadVO;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.ProjectVersionConvert;
import com.elitescloud.cloudt.system.model.vo.query.devops.ProjectVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ProjectVersionPageRespVO;
import com.elitescloud.cloudt.system.service.ProjectVersionMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysProjectVersionDO;
import com.elitescloud.cloudt.system.service.repo.ProjectVersionRepoProc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/2
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
public class ProjectVersionMngServiceImpl implements ProjectVersionMngService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectVersionMngServiceImpl.class);

    @Autowired
    private ProjectVersionRepoProc repoProc;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> upload(SysVersionUploadVO versionUploadVO) {
        var clientIp = HttpServletUtil.currentClientIp();
        if (CharSequenceUtil.hasBlank(versionUploadVO.getApplicationCode(), versionUploadVO.getProject(), versionUploadVO.getEnv())) {
            logger.info("上报的版本信息中缺少必要的信息，忽略上报：{}", clientIp);
            return ApiResult.fail("缺少必要的信息");
        }

        var versionDO = repoProc.getExistsRecord(versionUploadVO.getProject(), versionUploadVO.getEnv(), versionUploadVO.getApplicationCode());
        if (versionDO == null) {
            versionDO = new SysProjectVersionDO();
        }
        ProjectVersionConvert.INSTANCE.uploadVo2Do(versionUploadVO, versionDO);

        if (StringUtils.hasText(versionUploadVO.getBuildTime())) {
            versionDO.setBuildDateTime(DatetimeUtil.parseLocalDateTime(versionUploadVO.getBuildTime()));
        }
        versionDO.setReporterIp(clientIp);
        versionDO.setReportTime(LocalDateTime.now());

        repoProc.save(versionDO);

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<PagingVO<ProjectVersionPageRespVO>> pageMng(ProjectVersionPageQueryVO queryVO) {
        var pageData = repoProc.pageMng(queryVO).map(ProjectVersionConvert.INSTANCE::do2PageRespVO);

        return ApiResult.ok(pageData);
    }
}
