package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategySaveDTO;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyPlatformRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.PwdStrategySaveVO;
import com.elitescloud.cloudt.system.service.SystemMngService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/5
 */
@Service
public class SystemMngServiceImpl implements SystemMngService {

    @Autowired(required = false)
    private PwdStrategyTransferHelper pwdStrategyTransferHelper;

    @Override
    public ApiResult<Boolean> save(List<PwdStrategySaveVO> saveVOList) {
        if (pwdStrategyTransferHelper == null) {
            return ApiResult.fail("保存失败，未启用统一身份认证");
        }

        List<AuthPwdStrategySaveDTO> saveDTOList = new ArrayList<>(16);
        if (CollUtil.isNotEmpty(saveVOList)) {
            Set<String> existsCodes = new HashSet<>(16);
            for (PwdStrategySaveVO saveVO : saveVOList) {
                if (existsCodes.contains(saveVO.getStrategyCode())) {
                    continue;
                }
                existsCodes.add(saveVO.getStrategyCode());

                AuthPwdStrategySaveDTO saveDTO = new AuthPwdStrategySaveDTO();
                saveDTO.setStrategyCode(saveVO.getStrategyCode());
                saveDTO.setParams(saveVO.getParams());

                saveDTOList.add(saveDTO);
            }
        }
        // 保存策略
        var saveResult = pwdStrategyTransferHelper.save(saveDTOList);
        if (Boolean.FALSE.equals(saveResult.getSuccess())) {
            return ApiResult.fail(saveResult.getMsg());
        }

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<PwdStrategyConfigRespVO> getPwdStrategy() {
        if (pwdStrategyTransferHelper == null) {
            return ApiResult.fail("获取失败，未启用统一身份认证");
        }

        return this.getPwdStrategy(false);
    }

    @Override
    public ApiResult<PwdStrategyConfigRespVO> getDefaultPwdStrategy() {
        if (pwdStrategyTransferHelper == null) {
            return ApiResult.fail("获取失败，未启用统一身份认证");
        }

        return this.getPwdStrategy(true);
    }

    private ApiResult<PwdStrategyConfigRespVO> getPwdStrategy(boolean def) {
        // 查询策略
        var queryResult = def ? pwdStrategyTransferHelper.getDefault() : pwdStrategyTransferHelper.get();
        if (Boolean.FALSE.equals(queryResult.getSuccess())) {
            return ApiResult.fail(queryResult.getMsg());
        }

        PwdStrategyConfigRespVO respVO = new PwdStrategyConfigRespVO();
        var dataDTO = queryResult.getData();
        if (dataDTO == null) {
            respVO.setDefaultCfg(true);
            return ApiResult.ok(respVO);
        }
        respVO.setDefaultCfg(dataDTO.getDefaultCfg());
        respVO.setStrategyList(CollUtil.isEmpty(dataDTO.getStrategyList()) ? Collections.emptyList() :
                dataDTO.getStrategyList().stream().map(t -> {
                    PwdStrategyPlatformRespVO vo = new PwdStrategyPlatformRespVO();
                    vo.setCode(t.getCode());
                    vo.setName(t.getName());
                    vo.setExpression(t.getExpression());
                    vo.setParameters(t.getParameters());
                    vo.setReleatePlatform(t.getBound());
                    vo.setRequired(t.getRequired());

                    return vo;
                }).collect(Collectors.toList()));

        return ApiResult.ok(respVO);
    }
}
