package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstValueBO;
import com.elitescloud.cloudt.system.service.repo.DataRelationInstRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Component
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg = false)
public class DataRelationManager {
    @Autowired
    private DataRelationInstRepoProc instRepoProc;

    /**
     * 查询数据关联的值
     *
     * @param queryBO
     * @return
     */
    public List<DataRelationInstValueBO> queryValues(@NotNull DataRelationInstQueryBO queryBO) {
        return this.queryValues(queryBO, false);
    }

    /**
     * 查询被数据关联的值
     *
     * @param queryBO
     * @param byRef
     * @return
     */
    public List<DataRelationInstValueBO> queryValues(@NotNull DataRelationInstQueryBO queryBO, boolean byRef) {
        Assert.notBlank(queryBO.getDrCode(), "数据关系编码为空");
        boolean filterByAttribute = CollUtil.isNotEmpty(queryBO.getDataExt());

        return (byRef ? instRepoProc.getValuesByRef(queryBO) : instRepoProc.getValues(queryBO))
                .stream()
                .peek(t -> {
                    Map<String, String> dataExt = StringUtils.hasText(t.getDataExtJson()) ? JSONUtil.json2Obj(t.getDataExtJson(), new TypeReference<HashMap<String, String>>() {
                    }) : Collections.emptyMap();
                    t.setDataExt(dataExt);

                    Map<String, String> refDataExt = StringUtils.hasText(t.getRefDataExtJson()) ? JSONUtil.json2Obj(t.getRefDataExtJson(), new TypeReference<HashMap<String, String>>() {
                    }) : Collections.emptyMap();
                    t.setRefDataExt(refDataExt);
                })
                .filter(t -> {
                    if (!filterByAttribute) {
                        // 不需要根据属性过滤
                        return true;
                    }

                    for (Map.Entry<String, String> entry : queryBO.getDataExt().entrySet()) {
                        if (CharSequenceUtil.isBlank(entry.getKey())) {
                            continue;
                        }

                        if (byRef) {
                            if (!CharSequenceUtil.equals(entry.getValue(), t.getRefDataExt().get(entry.getKey()))) {
                                return false;
                            }
                        } else {
                            if (!CharSequenceUtil.equals(entry.getValue(), t.getDataExt().get(entry.getKey()))) {
                                return false;
                            }
                        }
                    }
                    return true;
                })
                .collect(Collectors.toList());
    }
}
