package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationParamDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Repository
public class BusinessOperationParamRepoProc extends BaseRepoProc<SysBusinessOperationParamDO> {
    private static final QSysBusinessOperationParamDO QDO = QSysBusinessOperationParamDO.sysBusinessOperationParamDO;

    public BusinessOperationParamRepoProc() {
        super(QDO);
    }

    /**
     * 根据OpenApiCode删除
     *
     * @param openApiCode
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteForGatherByOpenApiCode(@NotBlank String openApiCode) {
        var predicate = QDO.openApiCode.eq(openApiCode)
                .and(QDO.dataSource.in(OpenApiSourceEnum.GATHER_PULL.name(), OpenApiSourceEnum.GATHER_PUSH.name()));
        super.delete(predicate);
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessObjectId(long businessObjectId) {
        super.delete(QDO.businessObjectId.eq(businessObjectId));
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessObjectId(Collection<Long> businessObjectIds) {
        super.delete(QDO.businessObjectId.in(businessObjectIds));
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessOperationId(long businessOperationId) {
        super.delete(QDO.businessOperationId.eq(businessOperationId));
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessOperationId(Collection<Long> businessOperationIds) {
        super.delete(QDO.businessOperationId.in(businessOperationIds));
    }

    /**
     * 根据OpenApiCode查询
     *
     * @param openApiCode
     * @return
     */
    public List<SysBusinessOperationParamDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList(QDO.openApiCode.eq(openApiCode));
    }

    public List<BusinessOperationParamBO> listBoByOperationId(long businessOperationId, BusinessObjectParamInEnum paramIn) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.businessOperationId, businessOperationId)
                .andEq(QDO.paramIn, paramIn == null ? null : paramIn.getValue())
                .build();
        return super.getList(qBeanSimpleBO(), predicate);
    }


    public List<BusinessOperationParamBO> listBoByOperationCode(String businessOperationCode, BusinessObjectParamInEnum paramIn) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.businessOperationCode, businessOperationCode)
                .andEq(QDO.paramIn, paramIn == null ? null : paramIn.getValue())
                .build();
        return super.getList(qBeanSimpleBO(), predicate);
    }

    private QBean<BusinessOperationParamBO> qBeanSimpleBO() {
        return Projections.bean(BusinessOperationParamBO.class, QDO.id, QDO.businessOperationCode, QDO.fieldName, QDO.fieldDescription,
                QDO.fieldType, QDO.fieldJavaType,QDO.fieldPermissionFilter,
                QDO.request, QDO.ref, QDO.refValue, QDO.depth, QDO.paramPath, QDO.apiResult, QDO.pagingResult, QDO.paramIn, QDO.required,
                QDO.deprecated, QDO.single, QDO.enabled);
    }
}
