package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.vo.query.menu.MenuFavorPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysMenuFavorDO;
import com.elitescloud.cloudt.system.service.model.entity.SysMenuFavorDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/31
 */
@Repository
public class MenuFavorRepoProc extends BaseRepoProc<SysMenuFavorDO> {
    private static final QSysMenuFavorDO QDO = QSysMenuFavorDO.sysMenuFavorDO;

    public MenuFavorRepoProc() {
        super(QDO);
    }

    /**
     * 修改启用状态
     *
     * @param enabled
     * @param id
     */
    public void updateEnabled(Boolean enabled, Long id) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 获取启用状态
     *
     * @param id
     * @return
     */
    public Boolean getEnabled(Long id) {
        return super.getValue(QDO.enabled, id);
    }

    /**
     * 分页查询管理
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysMenuFavorDO> pageMng(@NotNull Long userId, @NotNull MenuFavorPageQueryVO queryVO, Collection<String> menuCodes) {
        var predicate = PredicateBuilder.builder()
                .andEq(true, QDO.userId, userId)
                .andIn(CollUtil.isNotEmpty(menuCodes), QDO.menuCode, menuCodes)
                .andEq(StringUtils.hasText(queryVO.getMenuCode()), QDO.menuCode, queryVO.getMenuCode())
                .andLike(StringUtils.hasText(queryVO.getShowName()), QDO.menuName, queryVO.getShowName())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }
}
