package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.PermissionResBO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysPermissionResDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPermissionResDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.*;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/29
 */
@Repository
public class PermissionResRepoProc extends BaseRepoProc<SysPermissionResDO> {
    private static final QSysPermissionResDO QDO = QSysPermissionResDO.sysPermissionResDO;

    public PermissionResRepoProc() {
        super(QDO);
    }

    public void delete(@NotNull BelongType.Belonger assigner, @NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId) {
        var predicate = QDO.ownerId.eq(ownerId).and(QDO.ownerType.eq(ownerType.name()))
                .and(QDO.assignerId.eq(assigner.getBelongId())).and(QDO.assignerType.eq(assigner.getBelongType().getValue()));
        super.delete(predicate);
    }

    public List<PermissionResBO.Res> listPermissionOfOwner(@NotNull BelongType.Belonger assigner, @NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId) {
        var predicate = QDO.ownerId.eq(ownerId).and(QDO.ownerType.eq(ownerType.name()))
                .and(QDO.assignerId.eq(assigner.getBelongId())).and(QDO.assignerType.eq(assigner.getBelongType().getValue()));
        return super.jpaQueryFactory.select(QDO.resType, QDO.resId)
                .from(QDO)
                .where(predicate)
                .fetch()
                .stream()
                .map(t -> {
                    PermissionResBO.Res res = new PermissionResBO.Res();
                    res.setResTypeEnum(MenuTreeNodeType.valueOf(t.get(QDO.resType)));
                    res.setResId(t.get(QDO.resId));

                    return res;
                }).collect(Collectors.toList());
    }

    public List<String> listMenuCodeByUsers(@NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId, boolean includeMenu,
                                     boolean includeAction) {
        Set<String> resTypes = new HashSet<>(4);
        if (includeMenu) {
            resTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            resTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (resTypes.isEmpty() || CharSequenceUtil.isBlank(ownerId)) {
            return Collections.emptyList();
        }

        var predicate = PredicateBuilder.builder()
                .andEq(QDO.ownerId, ownerId)
                .andEq(QDO.ownerType, ownerType.name())
                .andIn(QDO.resType, resTypes)
                .build();
        return super.getValueList(QDO.resId, predicate);
    }

    public List<String> listMenuCodeByUsers(@NotEmpty Map<String, PermissionOwnerTypeEnum> owners, boolean includeMenu,
                                            boolean includeAction) {
        Set<String> resTypes = new HashSet<>(4);
        if (includeMenu) {
            resTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            resTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (resTypes.isEmpty() || owners.isEmpty()) {
            return Collections.emptyList();
        }

        List<Predicate> predicateOwner = owners.entrySet().stream()
                .map(entry -> QDO.ownerId.eq(entry.getKey()).and(QDO.ownerType.eq(entry.getValue().name())))
                .collect(Collectors.toList());

        var predicate = PredicateBuilder.builder()
                .and(ExpressionUtils.anyOf(predicateOwner))
                .andIn(QDO.resType, resTypes)
                .build();
        return super.getValueList(QDO.resId, predicate);
    }
}
