package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysBankType;
import com.elitescloud.cloudt.system.convert.BankConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysBankBranchPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysBankPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.SysBankBranchRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.SysBankRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBankDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBankDO;
import com.querydsl.core.types.dsl.StringExpression;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/13 周四
 */
@Repository
public class SysBankRepoProc extends BaseRepoProc<SysBankDO> {
    private static final QSysBankDO QDO = QSysBankDO.sysBankDO;

    public SysBankRepoProc() {
        super(QDO);
    }

    public PagingVO<SysBankRespVO> pageQueryBank(SysBankPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.bankType, SysBankType.BANK.getValue())
                .andEq(QDO.bankCode, queryVO.getBankCode())
                .andLike(QDO.bankName, queryVO.getBankName())
                .andEq(QDO.outerCode, queryVO.getOuterCode())
                .andLike(new StringExpression[]{QDO.bankCode, QDO.bankName}, queryVO.getBankCodeOrName())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.sortNo.desc())
                .map(BankConvert.INSTANCE::do2BankRespVO);
    }

    public PagingVO<SysBankBranchRespVO> pageQueryBankBranch(SysBankBranchPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.bankType, SysBankType.BANK_BRANCH.getValue())
                .andEq(QDO.pcode, queryVO.getPcode())
                .andEq(QDO.bankCode, queryVO.getBankCode())
                .andLike(QDO.bankName, queryVO.getBankName())
                .andEq(QDO.outerCode, queryVO.getOuterCode())
                .andLike(new StringExpression[]{QDO.bankCode, QDO.bankName}, queryVO.getBankCodeOrName())
                .andEq(QDO.unitedBankNo, queryVO.getUnitedBankName())
                .andLike(QDO.unitedBankName, queryVO.getUnitedBankName())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.sortNo.desc())
                .map(BankConvert.INSTANCE::do2BankBranchRespVO);
    }
}
