package com.elitescloud.cloudt.system.util;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;

import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_BASIC_AUTH;
import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_OAUTH_V2;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 16:06
 * @Description: 认证账号转换工具
 */
public class AuthAccountResolve {


    /**
     * 根据认证方法和认证账户字符串获取BasicAuthAccountVO对象
     *
     * @param authMethod  认证方法，用于确定使用哪种认证方式
     * @param authAccount 认证账户信息字符串
     * @return 如果authAccount为空或者认证方法不是预设的基本认证方法，则返回null；否则返回转换后的BasicAuthAccountVO对象
     */
    public static BasicAuthAccountVO getBasicAuthAccount(String authMethod, String authAccount) {
        // 检查认证账户信息是否为空，为空则直接返回null
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        // 检查认证方法是否为基本认证方法，是则将认证账户信息转换为BasicAuthAccountVO对象并返回
        if (authMethod.equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(authAccount, BasicAuthAccountVO.class);
        }
        // 如果认证方法不是基本认证方法，则返回null
        return null;
    }

    /**
     * 根据认证方法和认证账户信息获取OAuth2账户信息
     *
     * @param authMethod  认证方法，用于确定使用哪种认证方式
     * @param authAccount 认证账户信息，这里是经过特定认证方法编码后的账户信息
     * @return 如果认证账户信息为空，则返回null；如果认证方法是OAuth2.0且账户信息有效，则返回解析后的OAuth2AccountVO对象
     */
    public static OAuth2AccountVO getOauth2Account(String authMethod, String authAccount) {
        // 检查认证账户信息是否为空，为空则直接返回null
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        // 检查认证方法是否为OAuth2.0，是则将认证账户信息解析为OAuth2AccountVO对象并返回
        if (authMethod.equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(authAccount, OAuth2AccountVO.class);
        }
        // 如果认证方法不是OAuth2.0，返回null
        return null;
    }
}
