package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.common.SnsBotProperties;
import com.elitescloud.cloudt.system.model.vo.BotMessage;
import com.elitescloud.cloudt.system.model.vo.BotRequest;
import com.elitescloud.cloudt.system.service.impl.BotSenderService;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.function.Supplier;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:19
 * @Description:
 */
@Slf4j
public class BotSender {
    private static final Logger logger = LoggerFactory.getLogger(BotSender.class);
    private static final String ERROR_MESSAGE = "告警机器人未启用";
    private static BotSenderService botSenderService;

    private static BotSenderService getInstance() {
        if (botSenderService == null) {
            botSenderService = (BotSenderService) SpringUtil.getBean(BotSenderService.class);
        }

        return botSenderService;
    }

    public static void push(Supplier<BotRequest> botSupplier, String message) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", "告警机器人未启用");
        } else {
            getInstance().push(botSupplier, message);
        }
    }

    public static void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", "告警机器人未启用");
        } else {
            getInstance().push(botSupplier, messages);
        }
    }

    public static void push(Supplier<BotRequest> botSupplier, Exception e) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", "告警机器人未启用");
        } else {
            getInstance().push(botSupplier, e);
        }
    }

    public static void push(BotRequest request) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", "告警机器人未启用");
        } else {
            getInstance().push(request);
        }
    }

    public BotSender() {
    }
}
