package com.elitescloud.cloudt.system.util;

import cn.hutool.core.exceptions.ExceptionUtil;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:07
 * @Description:
 */
public class ExceptionUtils extends ExceptionUtil {
    /**
     * 报错堆栈信息格式化
     */
    public static String formatException(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            sw.close();
            pw.close();
            return "\r\n" + sw + "\r\n";
        } catch (Exception e2) {
            return e.toString() + "\r\n" + e2;
        }
    }

    /**
     * 报错堆栈信息格式化，并截取最大长度
     */
    public static String formatException(Throwable e, int length) {
        return StringUtils.exceed(formatException(e), length);
    }
}
