package com.elitescloud.cloudt.ucenter.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.ucenter.api.dto.ArticleInfoDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.LinkAddressPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.*;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleCategorySaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleInfoSaveVO;
import com.elitescloud.cloudt.ucenter.dto.ArticleCategoryDTO;
import com.elitescloud.cloudt.ucenter.entity.ArticleCategoryDO;
import com.elitescloud.cloudt.ucenter.entity.ArticleInfoDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(config = BaseMapperConfig.class)
public interface ArticleManageConvert {
    ArticleManageConvert INSTANCE = Mappers.getMapper(ArticleManageConvert.class);

    ArticleCategoryDO categorySaveVOToDo(ArticleCategorySaveVO saveVO);

    ArticleInfoDO copyArticleInfoSaveToDo(ArticleInfoSaveVO saveVO);

    List<ArticleCategoryRespVO> categoryDtosToVos(List<ArticleCategoryDTO> queryUpCategory);

    List<ArticleInfoRespVO> copyInfoDTOsToVos(List<ArticleInfoDTO> records);

    List<ArticleCategoryRespVO> categoryDOsToVos(List<ArticleCategoryDO> infoDOS);

    ArticleInfoPagingParam paramToParam(LinkAddressPagingParam param);

    List<ArticleLinkRespVO> infoDTOsToVos(List<ArticleInfoDTO> records);

    ArticleInfoDetailRespVO infoDTO2DetailVo(ArticleInfoDTO dto);

    List<ArticleInfoCategoryRespVO> categoryDOsToRespVos(List<ArticleCategoryDO> categoryDOS);

    List<ArticleCategoryDTO> categoryDOs2DTOs(List<ArticleCategoryDO> categoryDOList);

    List<ArticleInfoCategoryRespVO> categoryDTOS2InfoCategoryRespVOs(List<ArticleCategoryDTO> treeDtoList);

    List<CategoryArticleRespVO> categoryDTOS2CategoryRespVOs(List<ArticleCategoryDTO> treeDtoList);
}
