package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "sys_common_search")
@org.hibernate.annotations.Table(appliesTo = "sys_common_search", comment = "通用查询")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class CommonSearchDO extends BaseModel implements Serializable {

    @Column(name = "common_search_id")
    private String commonSearchId;

    @Column(name = "common_search_name")
    private String commonSearchName;

    @Column(name = "common_search_content")
    private String commonSearchContent;

    @Column(name = "common_search_param")
    private String commonSearchParam;

    @Column(name = "connection_name")
    private String connectionName;

    @Column(name = "database_type")
    private String databaseType;

    @Column(name = "cache_flag")
    private Boolean cacheFlag;

    @Column(name = "cache_live_time")
    private BigDecimal cacheLiveTime;

    @Column(name = "sub_search")
    private String subSearch;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "password")
    private String password;

}