package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_receipt_source_config")
@org.hibernate.annotations.Table(appliesTo = "sys_receipt_source_config", comment = "单据来源配置")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ReceiptSourceConfigDO extends BaseModel implements Serializable {

    @Column(name = "source_no")
    private String sourceNo;

    @Column(name = "source_name")
    private String sourceName;

    @Column(name = "source_type")
    private String sourceType;

    @Column(name = "connect_url")
    private String connectUrl;

    @Column(name = "param_value")
    private String paramValue;

}
