package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.AdSpaceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface AdSpaceRepo extends JpaRepository<AdSpaceDO, Long>, QuerydslPredicateExecutor<AdSpaceDO> {

    List<AdSpaceDO> findAllByIdIn(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update sys_ad_space set delete_flag = ?2 where id = ?1", nativeQuery = true)
    void deleteAdSpace(Long id, String deleteFlag);

    @Query(value = "select ad_space_name from sys_ad_space where delete_flag = 0", nativeQuery = true)
    List<String> findAllSpaceName();

    boolean existsByAdSpaceName(String adSpaceName);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update sys_ad_space set delete_flag = ?2 where id in ?1", nativeQuery = true)
    void deleteAdSpaceByIds(List<Long> spaceIdList, String deleteFlag);

    AdSpaceDO findByAdSpaceCode(String adSpaceCode);

    @Query(value = "select ad_space_code as adSpaceCode from sys_ad_space where ad_title = ?1 and delete_flag = 0 limit 1", nativeQuery = true)
    AdSpaceDO findByAdTitle(String adTitle);
}
