package com.elitescloud.cloudt.ucenter.repo;


import com.elitescloud.cloudt.ucenter.entity.WebsiteBarDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 网站栏目信息
 *
 * @author chaofeng.xia
 * @date 2023/5/24 16:58
 */
@Repository
public interface WebsiteBarRepo extends JpaRepository<WebsiteBarDO, Long>, QuerydslPredicateExecutor<WebsiteBarDO> {

    List<WebsiteBarDO> findByPid(Long id);

    WebsiteBarDO findByHomePageFlag(Boolean homePageFlag);

    boolean existsByBarCode(String barCode);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set sort_no = ?2 where id = ?1", nativeQuery = true)
    Integer updateSortNoById(Long id, Integer sortNo);

    List<WebsiteBarDO> findByIdIn(List<Long> ids);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set delete_flag = 1 where pid in ?1", nativeQuery = true)
    Integer deleteByParentIdIn(List<Long> ids);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set show_flag = ?2 where id in ?1", nativeQuery = true)
    Integer updateShowFlagByIdIn(List<Long> ids, Boolean showFlag);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set delete_flag = 1 where id in ?1", nativeQuery = true)
    Integer deleteByIdIn(List<Long> ids);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set p_name = ?2 where pid in ?1", nativeQuery = true)
    Integer updatePNameByPid(Long pid,String pName);

    @Transactional
    @Modifying
    @Query(value = "update sys_website_bar set show_flag = ?2 where pid in ?1", nativeQuery = true)
    Integer updateShowFlagByPid(List<Long> ids,Boolean showFlag);
}

