-- ----------------------------
-- Table structure for sys_database_source
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_database_source`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id',
    `dbs_name`           varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_driver_class`   varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_url`            varchar(255) NOT NULL COMMENT '服务器地址',
    `dbs_username`       varchar(255) NOT NULL COMMENT '账号',
    `dbs_password`       varchar(255) NOT NULL COMMENT '密码',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '数据源表';

ALTER TABLE sys_database_source
    ADD COLUMN dbs_db_name VARCHAR(255) COMMENT '数据库名称',
    ADD COLUMN dbs_db_port VARCHAR(255) COMMENT '数据库端口';
-- ----------------------------
-- 租户
-- ----------------------------

CREATE TABLE `sys_database_service_tenant`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    `dbs_name`           varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_driver_class`   varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_url`            varchar(500) NOT NULL COMMENT '数据库链接字符串',
    `dbs_db_name`        varchar(255) NOT NULL COMMENT '数据库名称',
    `dbs_db_port`        varchar(255) NOT NULL COMMENT '数据库端口',
    `dbs_username`       varchar(255) NOT NULL COMMENT '账号',
    `dbs_password`       varchar(255) NOT NULL COMMENT '密码',
    `service_code`       varchar(255) NOT NULL COMMENT '服务编码',
    `tenant_code`        varchar(255) NOT NULL COMMENT '数据源租户编码',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `dbs_netaddress`     varchar(255) DEFAULT NULL COMMENT '服务器地址',
    PRIMARY KEY (`id`) USING BTREE
);



