/*
 Navicat Premium Data Transfer

 Source Server         : nctest
 Source Server Type    : MySQL
 Source Server Version : 50732 (5.7.32-2-log)
 Source Host           : eldb.elitescloud.com:3306
 Source Schema         : ayuyantest

 Target Server Type    : MySQL
 Target Server Version : 50732 (5.7.32-2-log)
 File Encoding         : 65001

 Date: 12/12/2023 13:53:28
*/


SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for observation_operation_log
-- ----------------------------
DROP TABLE IF EXISTS `observation_operation_log`;
CREATE TABLE `observation_operation_log`
(
    `id`                    bigint(20)                                                    NOT NULL AUTO_INCREMENT,
    `app_name`              varchar(255)   NULL     DEFAULT NULL COMMENT '应用标识 （非必填，默认：取值spring.application.name，微服务工程名）',
    `menu_code`             varchar(255)   NULL     DEFAULT NULL COMMENT '操作页面编码（非必填，默认：取值http request head获取请求）',
    `business_type`         varchar(255)   NOT NULL COMMENT '唯一业务类型（必填），业务对象名称，开发指定，规范：业务对象的名称应直观地描述其作用或所代表的实体，业务对象对应实体的DO名称 如：SysPlatformUdcDO，SysPlatformMenusDO',
    `business_type_name`    varchar(255)   NULL COMMENT '唯一业务类型（必填），业务对象名称中文',
    `business_param`        varchar(255)   NOT NULL COMMENT '唯一业务参数（必填），重要参数：产品或开发需求文档上标注，如：订单编号，员工编号。 用于操作日志查询）',
    `operation_type`        varchar(255)   NOT NULL COMMENT '操作类型，必填：使用OperationTypeEnum枚举 必填（枚举：创建，编辑，删除，审批，导出，导入，查询，其他）',
    `operation_type_name`   varchar(255)   NULL     DEFAULT NULL COMMENT '操作类型名称，默认：使用操作类型枚举名称，如果是其他类型，必填',
    `operation_description` text           NOT NULL COMMENT '操作描述（必填），操作主数据记录',
    `operation_before_data` text           NULL COMMENT '操作前数据存储（非必填）',
    `operation_after_data`  text           NULL COMMENT '操作后数据存储（非必填）',
    `operation_time`        varchar(255)   NOT NULL COMMENT '操作时间（必填）默认：当前时间',
    `operation_user_name`   varchar(255)   NULL     DEFAULT NULL COMMENT '操作人名称（非必填）默认：当前登录操作人',
    `operation_user_id`     bigint(20)                                                    NULL     DEFAULT NULL COMMENT '操作人ID（非必填）默认：当前登录操作人',
    `request_url`           varchar(255)   NULL     DEFAULT NULL COMMENT '操作请求地址 （非必填）默认：通过HTTP REQUEST获取地址',
    `tenant_id`             bigint(20)                                                    NULL     DEFAULT NULL COMMENT '租户ID：默认：当前操作人租户',
    `request_method`        varchar(255)   NULL     DEFAULT NULL COMMENT '请求方式（非必填）默认：通过HTTP REQUEST获取',
    `operation_ip`          varchar(255)   NULL     DEFAULT NULL COMMENT '操作IP （非必填）默认：当前请求IP',
    `success`               tinyint(1)                                                    NOT NULL DEFAULT 0 COMMENT '是否成功（必填） 默认：false',
    `exception_desc`        text           NULL COMMENT '失败描述，成功非必填，失败必填',
    `token`                 text           NULL COMMENT 'token',
    `ext1`                  text           NULL COMMENT '扩展1',
    `ext2`                  text           NULL COMMENT '扩展2',
    `ext3`                  text           NULL COMMENT '扩展3',
    `source`                varchar(255)   NULL     DEFAULT NULL COMMENT '数据来源',
    `operation_name`        varchar(255)   NULL     DEFAULT NULL COMMENT '操作人名称',
    `trace_id_sys`          varchar(255)   NULL     DEFAULT NULL COMMENT '链路ID-系统生成',
    `trace_id_ext`          varchar(255)   NULL     DEFAULT NULL COMMENT '链路ID-其他链路工具，默认sk',
    `creation_date`         datetime                                                      NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `sys_delayed`           bigint(20)                                                    NOT NULL DEFAULT 0 COMMENT '耗时',
    PRIMARY KEY (`id`, `creation_date`) USING BTREE,
    INDEX `business_param_index` (`business_param`) USING BTREE,
    INDEX `business_type` (`business_type`) USING BTREE,
    INDEX `operation_type` (`operation_type`) USING BTREE,
    INDEX `operation_time` (`operation_time`) USING BTREE,
    INDEX `menu_code` (`menu_code`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 4
  COMMENT = '业务操作日志表-人工'
  ROW_FORMAT = DYNAMIC PARTITION BY RANGE (YEAR(creation_date))
    PARTITIONS 8
    (PARTITION `p2023` VALUES LESS THAN (2023) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2024` VALUES LESS THAN (2024) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2025` VALUES LESS THAN (2025) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2026` VALUES LESS THAN (2026) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2027` VALUES LESS THAN (2027) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2028` VALUES LESS THAN (2028) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2029` VALUES LESS THAN (2029) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `pMax` VALUES LESS THAN (MAXVALUE) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 )
;

SET FOREIGN_KEY_CHECKS = 1;


/*
 Navicat Premium Data Transfer

 Source Server         : nctest
 Source Server Type    : MySQL
 Source Server Version : 50732 (5.7.32-2-log)
 Source Host           : eldb.elitescloud.com:3306
 Source Schema         : ayuyantest

 Target Server Type    : MySQL
 Target Server Version : 50732 (5.7.32-2-log)
 File Encoding         : 65001

 Date: 12/12/2023 13:53:28
*/


SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for observation_operation_log
-- ----------------------------
DROP TABLE IF EXISTS `observation_operation_auto_log`;
CREATE TABLE `observation_operation_auto_log`
(
    `id`                    bigint(20)                                                    NOT NULL AUTO_INCREMENT,
    `app_name`              varchar(255)   NULL     DEFAULT NULL COMMENT '应用标识 （非必填，默认：取值spring.application.name，微服务工程名）',
    `menu_code`             varchar(255)   NULL     DEFAULT NULL COMMENT '操作页面编码（非必填，默认：取值http request head获取请求）',
    `business_type`         varchar(255)   NOT NULL COMMENT '唯一业务类型（必填），业务对象名称，开发指定，规范：业务对象的名称应直观地描述其作用或所代表的实体',
    `business_type_name`    varchar(255)   NULL COMMENT '唯一业务类型（必填），业务对象名称中文',
    `business_param`        varchar(255)   NULL COMMENT '唯一业务参数（必填），重要参数：产品或开发需求文档上标注，如：订单编号，员工编号。 用于操作日志查询）',
    `operation_type`        varchar(255)   NOT NULL COMMENT '操作类型，必填：使用OperationTypeEnum枚举 必填（枚举：创建，编辑，删除，审批，导出，导入，查询，其他）',
    `operation_type_name`   varchar(255)   NULL     DEFAULT NULL COMMENT '操作类型名称，默认：使用操作类型枚举名称，如果是其他类型，必填',
    `operation_description` text           NOT NULL COMMENT '操作描述（必填），操作主数据记录',
    `operation_before_data` text           NULL COMMENT '操作前数据存储（非必填）',
    `operation_after_data`  text           NULL COMMENT '操作后数据存储（非必填）',
    `operation_time`        varchar(255)   NOT NULL COMMENT '操作时间（必填）默认：当前时间',
    `operation_user_name`   varchar(255)   NULL     DEFAULT NULL COMMENT '操作人名称（非必填）默认：当前登录操作人',
    `operation_user_id`     bigint(20)                                                    NULL     DEFAULT NULL COMMENT '操作人ID（非必填）默认：当前登录操作人',
    `request_url`           varchar(255)   NULL     DEFAULT NULL COMMENT '操作请求地址 （非必填）默认：通过HTTP REQUEST获取地址',
    `tenant_id`             bigint(20)                                                    NULL     DEFAULT NULL COMMENT '租户ID：默认：当前操作人租户',
    `request_method`        varchar(255)   NULL     DEFAULT NULL COMMENT '请求方式（非必填）默认：通过HTTP REQUEST获取',
    `operation_ip`          varchar(255)   NULL     DEFAULT NULL COMMENT '操作IP （非必填）默认：当前请求IP',
    `success`               tinyint(1)                                                    NOT NULL DEFAULT 0 COMMENT '是否成功（必填） 默认：false',
    `exception_desc`        text           NULL COMMENT '失败描述，成功非必填，失败必填',
    `token`                 text           NULL COMMENT 'token',
    `ext1`                  text           NULL COMMENT '扩展1',
    `ext2`                  text           NULL COMMENT '扩展2',
    `ext3`                  text           NULL COMMENT '扩展3',
    `source`                varchar(255)   NULL     DEFAULT NULL COMMENT '数据来源',
    `operation_name`        varchar(255)   NULL     DEFAULT NULL COMMENT '操作人名称',
    `trace_id_sys`          varchar(255)   NULL     DEFAULT NULL COMMENT '链路ID-系统生成',
    `trace_id_ext`          varchar(255)   NULL     DEFAULT NULL COMMENT '链路ID-其他链路工具，默认sk',
    `creation_date`         datetime                                                      NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `sys_delayed`           bigint(20)                                                    NOT NULL DEFAULT 0 COMMENT '耗时',

    PRIMARY KEY (`id`, `creation_date`) USING BTREE,
    INDEX `business_param_index` (`business_param`) USING BTREE,
    INDEX `business_type` (`business_type`) USING BTREE,
    INDEX `operation_type` (`operation_type`) USING BTREE,
    INDEX `operation_time` (`operation_time`) USING BTREE,
    INDEX `menu_code` (`menu_code`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 4
  COMMENT = '业务操作日志表-自动'
  ROW_FORMAT = DYNAMIC PARTITION BY RANGE (YEAR(creation_date))
    PARTITIONS 8
    (PARTITION `p2023` VALUES LESS THAN (2023) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2024` VALUES LESS THAN (2024) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2025` VALUES LESS THAN (2025) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2026` VALUES LESS THAN (2026) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2027` VALUES LESS THAN (2027) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2028` VALUES LESS THAN (2028) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `p2029` VALUES LESS THAN (2029) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 ,
    PARTITION `pMax` VALUES LESS THAN (MAXVALUE) ENGINE = InnoDB MAX_ROWS = 0 MIN_ROWS = 0 )
;

SET FOREIGN_KEY_CHECKS = 1;
