-- `cloudt3-system`.sys_orgbu_tree_employee definition

CREATE TABLE `sys_orgbu_tree_employee`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_id`         bigint       DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint       DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT '组织编号',
    `employee_id`        bigint       DEFAULT NULL COMMENT '员工id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='组织树员工关系';

ALTER TABLE sys_orgbu_tree_employee
    ADD position_id BIGINT NULL COMMENT '岗位ID';
ALTER TABLE sys_orgbu_tree_employee
    ADD leader_user_id BIGINT NULL COMMENT '领导用户ID';
ALTER TABLE sys_orgbu_tree_employee
    ADD leader_employee_id BIGINT NULL COMMENT '领导员工ID';