CREATE TABLE `sys_bank`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `bank_type`          varchar(32)  NOT NULL COMMENT '银行类型, [UDC]cloudt-system:sysBank',
    `bank_code`          varchar(32)  NOT NULL COMMENT '银行编号',
    `bank_name`          varchar(128) NOT NULL COMMENT '银行名称',
    `pcode`              varchar(32)  DEFAULT NULL COMMENT '上级编码',
    `united_bank_no`     varchar(32)  DEFAULT NULL COMMENT '人行联行行号',
    `united_bank_name`   varchar(128) DEFAULT NULL COMMENT '人行联行名称',
    `outer_code`         varchar(32)  DEFAULT NULL COMMENT '外部编码',
    `sort_no`            int          DEFAULT NULL COMMENT '排序号',
    `detail_addr`        varchar(256) DEFAULT NULL COMMENT '详细地址',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_bank_type` (`bank_type`),
    KEY `idx_sys_bank_code` (`bank_code`),
    KEY `idx_sys_bank_pcode` (`pcode`)
) COMMENT ='银行信息';