/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.datadiff.context;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.elitescloud.cloudt.datadiff.vo.AuditDiffVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AuditLogContext {
    private static final TransmittableThreadLocal<StandardEvaluationContext> CONTEXT_THREAD_LOCAL = new TransmittableThreadLocal();
    public static final String CONTEXT_KEY_NAME_RETURN = "_return";
    public static final String CONTEXT_KEY_NAME_ERROR_MSG = "_errorMsg";
    private static final TransmittableThreadLocal<List<AuditDiffVO>> DIFF_VO_LIST_THREAD_LOCAL = new TransmittableThreadLocal();

    public static StandardEvaluationContext getContext() {
        return (StandardEvaluationContext)ObjectUtil.defaultIfNull((Object)((StandardEvaluationContext)CONTEXT_THREAD_LOCAL.get()), (Object)new StandardEvaluationContext());
    }

    public static void putVariable(String key, Object value) {
        StandardEvaluationContext context = AuditLogContext.getContext();
        context.setVariable(key, value);
        CONTEXT_THREAD_LOCAL.set((Object)context);
    }

    public static Object getVariable(String key) {
        StandardEvaluationContext context = AuditLogContext.getContext();
        return context.lookupVariable(key);
    }

    public static void clearContext() {
        CONTEXT_THREAD_LOCAL.remove();
    }

    public static List<AuditDiffVO> getDiffVOList() {
        return (List)CollUtil.defaultIfEmpty((Collection)((List)DIFF_VO_LIST_THREAD_LOCAL.get()), new ArrayList());
    }

    public static void addDiff(AuditDiffVO auditDiffVO) {
        if (auditDiffVO != null) {
            List<AuditDiffVO> auditDiffVOList = AuditLogContext.getDiffVOList();
            auditDiffVOList.add(auditDiffVO);
            DIFF_VO_LIST_THREAD_LOCAL.set(auditDiffVOList);
        }
    }

    public static void clearDiffVOList() {
        DIFF_VO_LIST_THREAD_LOCAL.remove();
    }
}

