/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.log.controller;

import com.elitescloud.boot.log.common.EventTrackingInterface;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingLogLevelEnum;
import com.elitescloud.cloudt.log.model.vo.param.LogStashQueryParam;
import com.elitescloud.cloudt.log.model.vo.resp.LogStashRecordRespVO;
import com.elitescloud.cloudt.log.service.LogStashService;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserFieldRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logStash"})
@Api(tags={"\u7cfb\u7edf\u65e5\u5fd7"})
public class LogStashController {
    @Autowired(required=false)
    private LogStashService logStashService;
    @Autowired
    private EventTrackingInterface eventTrackingInterface;

    @GetMapping(value={"/appName"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u540d\u79f0\u5217\u8868")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="size", value="\u83b7\u53d6\u540d\u79f0\u7684\u6700\u591a\u6570\u91cf\uff0c\u9ed8\u8ba420"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4"), @ApiImplicitParam(name="endTime", value="\u622a\u6b62\u65f6\u95f4")})
    public ApiResult<List<String>> queryAppName(Integer size, LocalDateTime startTime, LocalDateTime endTime, List<String> dd, List<UserFieldRespVO> mm) {
        return this.logStashService.appNameList(size, startTime, endTime);
    }

    @GetMapping(value={"/logLevel"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u7ea7\u522b\u5217\u8868")
    @ApiOperationSupport(order=2)
    public ApiResult<List<String>> queryLogLevel() {
        return this.logStashService.logLevelList();
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u641c\u7d22\u65e5\u5fd7")
    @ApiOperationSupport(order=3)
    public ApiResult<PagingVO<LogStashRecordRespVO>> search(@RequestBody LogStashQueryParam queryParam) {
        return this.logStashService.search(queryParam);
    }

    @PostMapping(value={"/testEventTrackingLog"})
    @ApiOperation(value="\u57cb\u70b9\u65e5\u5fd7\u91c7\u96c6")
    @ApiOperationSupport(order=4)
    public ApiResult<Object> testEventTrackingLog(@RequestBody String contest) {
        this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.ERROR, "\u57cb\u70b9\u65e5\u5fd7\u91c7\u96c6ERROR{}", new Object[]{contest});
        this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.INFO, "\u57cb\u70b9\u65e5\u5fd7\u91c7\u96c6INFO{}", new Object[]{contest});
        this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.DEBUG, "\u57cb\u70b9\u65e5\u5fd7\u91c7\u96c6DEBUG{}", new Object[]{contest});
        return ApiResult.ok((Object)contest);
    }
}

